/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.slang.AbstractConsumerOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.List;
import java.util.stream.Collectors;

public class StartConsumerOperation
extends AbstractConsumerOperation {
    private static final String NAME = "start consumer";

    public StartConsumerOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("START CONSUMER").addActionParameter(new IdentifierParameter("Name"));
        this.syntax.setDescription("Starts the specified console consumer.");
        this.syntax.addCompletionCommand("list console consumers");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((SLANGTool)this.callable).getConsumers().stream().filter(consumer -> !consumer.isStarted).map(consumer -> consumer.name).collect(Collectors.toList()));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractConsumerOperation.Definition(NAME, statement.getParameter("Name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        boolean async = ((SLANGTool)this.callable).startConsumer(((AbstractConsumerOperation.Definition)statement).consumerName);
        return async ? new SLResponse(SLANGTool.getAsyncConsumerMessage()) : new PseudoSLResponse();
    }
}

