/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.Map;

class SetSessionDiscoveryPropertiesOperation
extends AbstractSessionOperation {
    public static final String NAME = "set session discovery properties";

    public SetSessionDiscoveryPropertiesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET SESSION DISCOVERY PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHintSpace());
        this.syntax.setDescription("Sets the specified configuration properties that are used to discover available links for connection.");
        this.syntax.setSyntaxDescription("The following parameters are supported:\n\n   fabricDirectory       - Path to file containing the Directory Table.\n                           Directory Table contains links that the tool can connect to.\n   multicastEnabled      - Enables or disables multicast (UDP) discovery.\n                           Multicast response contains links that the tool can connect to.\n   multicastWaitingTime  - Wait time (in seconds) of multicast response.\n                           If the time is negative (< 0) the module does not wait for multicast responses.\n   multicastAddress      - Address (host:port) that is used for sending multicast requests.");
        this.syntax.setExamples("set session discovery properties (fabricDirectory = 'DirectoryTable.xdo')\nset session discovery properties (multicastEnabled = 'true', multicastWaitingTime = '1', multicastAddress = '230.0.0.0:8889')");
        this.syntax.addTag(OperationTag.discovery);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        DiscoveryModuleConfiguration configuration = ((SLANGTool)this.callable).getContext().getDiscoveryModuleFactory().getActiveModuleConfiguration();
        for (Map.Entry<String, String> entry : ((Definition)statement).properties.entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue(), configuration);
        }
        return new SLResponse();
    }

    private void setParameter(String name, String value, DiscoveryModuleConfiguration configuration) throws Exception {
        if (name.equalsIgnoreCase("fabricDirectory")) {
            ((SLANGTool)this.callable).setDiscoveryFabricDirectory(value);
        } else if (name.equalsIgnoreCase("multicastEnabled")) {
            ((SLANGTool)this.callable).setDiscoveryMulticastEnabled(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase("multicastWaitingTime")) {
            ((SLANGTool)this.callable).setDiscoveryMulticastWaitingTime(SetParametersModifier.getLong(name, value));
        } else if (name.equalsIgnoreCase("multicastAddress")) {
            ((SLANGTool)this.callable).setDiscoveryMulticastAddress(value);
        } else {
            throw new FabricException("Unknown property '" + name + "'.");
        }
        if (configuration != null) {
            configuration.setParameter(name, value);
        }
    }

    static class Definition
    extends AbstractSLStatement {
        private Map<String, String> properties;

        Definition(Map<String, String> properties) {
            super(SetSessionDiscoveryPropertiesOperation.NAME);
            this.properties = properties;
        }
    }
}

