/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.JVM;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.nio.charset.Charset;

class SetSessionCCSIDOperation
extends AbstractSessionOperation {
    public static final String NAME = "set session ccsid";

    SetSessionCCSIDOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET SESSION CCSID").addActionParameter(new StringParameter("ccsid"));
        this.syntax.setDescription("Sets default session CCSID(Coded Character Set ID). Session CCSID overloads default datastore CCSID.\nCCSID is used in file operations like read/write file and directory table operations\nwhere characters encoding/decoding is needed.");
        this.syntax.setExamples("set session ccsid 'UTF-8'");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return JVM.isWindowsOS() && this.callable instanceof SLANGTool && ((SLANGTool)this.callable).isConnected() && !((SLANGTool)this.callable).isAnonymous();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SLResponse response = ((SLANGTool)this.callable).invokeSessionRequest(definition.statement.getOriginalStatement());
        if (response.isOK()) {
            ((SLANGTool)this.callable).setConsoleCCSID(Charset.forName(definition.statement.getParameter("ccsid").getValue()));
        }
        return response;
    }

    static class Definition
    extends AbstractSLStatement {
        private DSLStatement statement;

        Definition(DSLStatement statement) {
            super(SetSessionCCSIDOperation.NAME);
            this.statement = statement;
        }
    }
}

