/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class SetReplyTimeoutOperation
extends AbstractSessionOperation {
    private static final String NAME = "set reply timeout";

    SetReplyTimeoutOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET REPLY TIMEOUT").addActionParameter(new IntegerParameter("timeout").setRange(0, Integer.MAX_VALUE));
        this.syntax.setDescription("Sets the wait time (in seconds) for a reply to SLANG request.\nDefault is 30 seconds.\nThis timeout is persistent between slang tool restarts.");
        this.syntax.setExamples("set reply timeout 60");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(Integer.parseInt(statement.getParameter("timeout").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((SLANGTool)this.callable).setReplyTimeout(((Definition)statement).timeout * 1000L);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private long timeout;

        Definition(long timeout) {
            super(SetReplyTimeoutOperation.NAME);
            this.timeout = timeout;
        }
    }
}

