/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class SetReconnectIntervalOperation
extends AbstractSessionOperation {
    private static final String NAME = "set reconnect interval";

    SetReconnectIntervalOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET RECONNECT INTERVAL").addActionParameter(new LongParameter("Interval").setRange(1L, Long.MAX_VALUE));
        this.syntax.setDescription("Sets a time (in seconds) between successive reconnect attempts after connection break.\nDefault is 30 seconds.");
        this.syntax.setExamples("set reconnect interval 10");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(Long.parseLong(statement.getParameter("Interval").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((SLANGTool)this.callable).setReconnectInterval(((Definition)statement).reconnectInterval);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private long reconnectInterval;

        Definition(long reconnectInterval) {
            super(SetReconnectIntervalOperation.NAME);
            this.reconnectInterval = reconnectInterval;
        }
    }
}

