/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class SetReconnectAttemptsOperation
extends AbstractSessionOperation {
    private static final String NAME = "set reconnect attempts";

    SetReconnectAttemptsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET RECONNECT ATTEMPTS").addActionParameter(new IntegerParameter("Attempts"));
        this.syntax.setDescription("Sets a number of reconnect attempts after connection break.\nDefault is -1.\nNegative value means that a number of reconnect attempts is not limited (until successful connecting).");
        this.syntax.setExamples("set reconnect attempts 3");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(Integer.parseInt(statement.getParameter("Attempts").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((SLANGTool)this.callable).setReconnectAttempts(((Definition)statement).reconnectAttempts);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private int reconnectAttempts;

        Definition(int reconnectAttempts) {
            super(SetReconnectAttemptsOperation.NAME);
            this.reconnectAttempts = reconnectAttempts;
        }
    }
}

