/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class SetPromptOperation
extends AbstractSessionOperation {
    private static final String NAME = "set prompt";

    SetPromptOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET PROMPT");
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("PromptType").addPossibleValues("basic", "extended").setSyntaxHintSpace());
        this.syntax.setDescription("Sets the type of prompt.");
        this.syntax.setExamples("set prompt basic\nset prompt extended");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("basic"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        boolean basicPrompt = ((Definition)statement).basicPrompt;
        if (basicPrompt != ((SLANGTool)this.callable).isBasicPrompt()) {
            ((SLANGTool)this.callable).setBasicPrompt(basicPrompt);
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private boolean basicPrompt;

        Definition(boolean basicPrompt) {
            super(SetPromptOperation.NAME);
            this.basicPrompt = basicPrompt;
        }
    }
}

