/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class SetMaxColumnWidthOperation
extends AbstractSessionOperation {
    private static final String NAME = "set max column width";

    SetMaxColumnWidthOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET MAX COLUMN WIDTH").addActionParameter(new IntegerParameter("width").setRange(0, Integer.MAX_VALUE));
        this.syntax.setDescription("Sets a max column width of table responses.\nDefault is " + RowSetPrinter.DEFAULT_MAX_COLUMN_WIDTH + ".");
        this.syntax.setExamples("set max column width 80");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(Integer.parseInt(statement.getParameter("width").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((SLANGTool)this.callable).setMaxColumnWidth(((Definition)statement).width);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private int width;

        Definition(int width) {
            super(SetMaxColumnWidthOperation.NAME);
            this.width = width;
        }
    }
}

