/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.Trace;
import com.streamscape.lib.utils.JVM;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.tools.slang.plot.PlotData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class STPlotterRunner {
    private String javaHome;
    private String javaExecutable;
    private String platformLibPath;
    private String stplotterJar = "stplotter.jar";
    private String classpath;
    private Process process;
    private CloseChildThread closeChildThread;
    private StreamReader processStreamReader;

    public STPlotterRunner() {
        if (System.getenv("STROOT") != null) {
            this.platformLibPath = System.getenv("STROOT") + "/platform/lib";
        }
        if (System.getenv("JAVA_HOME") != null) {
            this.javaHome = System.getenv("JAVA_HOME");
        }
        this.javaExecutable = JVM.isWindowsOS() ? "java.exe" : "java";
    }

    public void start() throws IOException {
        Object cp;
        if (this.platformLibPath == null && this.classpath == null) {
            throw new IOException("Platform lib path and classpath does not set. Set STROOT variable or set path/classpath directly.");
        }
        if (this.stplotterJar == null) {
            throw new IOException("Slang jar doesn't set.");
        }
        Object java = this.javaExecutable;
        if (this.javaHome != null) {
            java = this.javaHome + "/bin/" + this.javaExecutable;
        }
        if ((cp = this.classpath) == null) {
            cp = this.platformLibPath + "/" + this.stplotterJar;
        }
        if (!Files.exists(Paths.get((String)cp, new String[0]), new LinkOption[0])) {
            throw new IOException("stplotter.jar not found.");
        }
        Trace.logDebug(this, "Launching stplotter with command '" + (String)java + " -jar " + (String)cp + "'...");
        this.process = new ProcessBuilder(new String[]{java, "-jar", cp}).redirectErrorStream(true).start();
        this.processStreamReader = new StreamReader(this);
        this.closeChildThread = new CloseChildThread();
        Runtime.getRuntime().addShutdownHook(this.closeChildThread);
    }

    public void stop() {
        this.close();
    }

    protected void close() {
        if (this.process != null) {
            try {
                this.process.destroy();
                this.process.waitFor();
            }
            catch (InterruptedException exception) {
                Trace.logError(this, "Destroying SLANG process failed. Cause: " + exception.toString());
            }
            finally {
                this.process = null;
            }
        }
        if (this.closeChildThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.closeChildThread);
            this.closeChildThread = null;
        }
    }

    public void write(PlotData data) throws IOException, SerializerException {
        String json = ((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)((JSONSerializer.JsonSerializerBuilderImpl)JSONSerializer.builder().setName("Plotter")).setJsonNotationLevel(JsonNotationLevel.NONE)).setJsonNotation(JsonNotation.TYPE)).setAliasManager(new ObjectMediationAliasManager())).build().withPrettyPrint(false).serialize(data);
        this.process.getOutputStream().write(json.getBytes());
        this.process.getOutputStream().write("\n".getBytes());
        this.process.getOutputStream().flush();
    }

    public StreamReader getStreamReader() {
        return this.processStreamReader;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public String getPlatformLibPath() {
        return this.platformLibPath;
    }

    public void setPlatformLibPath(String platformLibPath) {
        this.platformLibPath = platformLibPath;
    }

    public String getSlangJar() {
        return this.stplotterJar;
    }

    public void setSlangJar(String slangJar) {
        this.stplotterJar = slangJar;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public class StreamReader {
        private BufferedReader inputReader;

        StreamReader(STPlotterRunner this$0) {
            this.inputReader = new BufferedReader(new InputStreamReader(this$0.process.getInputStream()));
        }

        void close() throws IOException {
            this.inputReader.close();
        }

        void skipAll() throws IOException {
            while (this.inputReader.ready()) {
                this.inputReader.skip(1000L);
            }
        }

        public String readLine(long timeout) throws IOException {
            block7: {
                String line;
                if (timeout == -1L) {
                    timeout = 20000L;
                }
                do {
                    long startTime = System.currentTimeMillis();
                    while (System.currentTimeMillis() - startTime < timeout && !this.inputReader.ready()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!this.inputReader.ready()) break block7;
                    line = this.inputReader.readLine();
                    if ("Plotter: exception:".equals(line)) {
                        StringBuilder builder = new StringBuilder();
                        while ((line = this.readLine(1000L)) != null) {
                            builder.append(line).append("\n");
                        }
                        throw new IOException(builder.toString());
                    }
                    if (!"Plotter: displayed..".equals(line)) continue;
                    return null;
                } while (line != null && line.startsWith("SLF4J:"));
                return line;
            }
            return null;
        }
    }

    private class CloseChildThread
    extends Thread {
        private CloseChildThread() {
        }

        @Override
        public void run() {
            if (STPlotterRunner.this.process != null) {
                STPlotterRunner.this.process.destroy();
            }
        }
    }
}

