/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.Trace;
import com.streamscape.lib.utils.JVM;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.tools.slang.WrappedSLANGTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class SLANGToolWrapper {
    private String javaHome;
    private String javaExecutable;
    private String platformLibPath;
    private String slangJar = "slang.jar";
    private String classpath;
    private Process slangProcess;
    private CloseChildThread closeChildThread;
    private StreamReader slangStreamReader;
    private static final long START_TIMEOUT = 10000L;

    public SLANGToolWrapper() {
        if (System.getenv("STROOT") != null) {
            this.platformLibPath = System.getenv("STROOT") + "/platform/lib";
            this.javaHome = System.getenv("STROOT") + "/platform/jre";
            if (!new File(this.javaHome).exists() && System.getenv("JAVA_HOME") != null) {
                this.javaHome = System.getenv("JAVA_HOME");
            }
        } else if (System.getenv("JAVA_HOME") != null) {
            this.javaHome = System.getenv("JAVA_HOME");
        }
        this.javaExecutable = JVM.isWindowsOS() ? "java.exe" : "java";
    }

    public void start() throws IOException {
        Object cp;
        this.close();
        if (this.platformLibPath == null && this.classpath == null) {
            throw new IOException("Platform lib path and classpath do not set. Set STROOT variable or set path/classpath directly.");
        }
        if (this.slangJar == null) {
            throw new IOException("SLANG jar does not set.");
        }
        Object java = this.javaExecutable;
        if (this.javaHome != null) {
            java = this.javaHome + "/bin/" + this.javaExecutable;
        }
        if ((cp = this.classpath) == null) {
            cp = this.platformLibPath + "/" + this.slangJar;
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(java, "-cp", cp));
        if (JVM.is14()) {
            command.addAll(Arrays.asList("--add-opens=java.base/jdk.internal.loader=ALL-UNNAMED", "--add-opens=java.base/sun.net.www=ALL-UNNAMED", "--add-opens=java.base/sun.security.util=ALL-UNNAMED", "--add-opens=java.base/sun.nio.ch=ALL-UNNAMED", "--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED", "--add-opens=java.xml/com.sun.org.apache.xerces.internal.jaxp.datatype=ALL-UNNAMED", "--add-opens=java.base/sun.net.www.protocol.jar=ALL-UNNAMED", "--add-opens=java.base/sun.security.provider=ALL-UNNAMED", "--add-opens=java.base/sun.reflect.generics.reflectiveObjects=ALL-UNNAMED", "--add-opens=java.base/jdk.internal.misc=ALL-UNNAMED", "--add-opens=java.base/sun.security.action=ALL-UNNAMED", "--add-opens=java.base/sun.security.pkcs=ALL-UNNAMED", "--add-opens=java.base/jdk.internal.reflect=ALL-UNNAMED", "--add-opens=java.base/jdk.internal.access=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.base/java.text=ALL-UNNAMED", "--add-opens=java.desktop/java.awt.font=ALL-UNNAMED", "--add-opens=java.base/java.net=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/sun.security.rsa=ALL-UNNAMED", "--add-opens=java.base/sun.nio.cs=ALL-UNNAMED"));
        }
        command.add(WrappedSLANGTool.class.getName());
        Trace.logDebug(this, "Launching SLANG tool with command '" + command.stream().map(s -> s + " ").collect(Collectors.joining()) + "'...");
        this.slangProcess = new ProcessBuilder(command).redirectErrorStream(true).start();
        try {
            this.slangStreamReader = new StreamReader();
            if (this.slangStreamReader.read(10000L) != WrappedSLANGTool.StreamDelimiter.SLANG_STARTED) {
                throw new IOException("Startup signal was not received from SLANG tool.");
            }
        }
        catch (IOException exception) {
            Trace.logError(this, "Starting SLANG tool failed (exception : " + exception.toString() + ", output: " + this.slangStreamReader.getLastBuffer().toString() + ").");
            this.close();
            throw exception;
        }
        this.checkSlangProcessStatus();
        this.closeChildThread = new CloseChildThread();
        Runtime.getRuntime().addShutdownHook(this.closeChildThread);
    }

    public boolean isRunning() {
        try {
            this.checkSlangProcessStatus();
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    public void stop() {
        try {
            this.slangRequest("exit");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public SLResponse connect(String url, String user, String password) throws IOException {
        return this.slangRequest("connect " + url + " '" + user + "' '" + password + "'");
    }

    public SLResponse disconnect() throws IOException {
        return this.slangRequest("disconnect");
    }

    public SLResponse setReplyTimeout(long timeout) throws IOException {
        return this.slangRequest("set reply timeout " + timeout);
    }

    public SLResponse getReplyTimeout() throws IOException {
        return this.slangRequest("get reply timeout");
    }

    public SLResponse slangRequest(String request) throws IOException {
        this.checkSlangProcessStatus();
        this.slangStreamReader.skipAll();
        this.slangStreamReader.resetLastBuffer();
        request = (String)request + "\n";
        this.slangProcess.getOutputStream().write(((String)request).getBytes());
        this.slangProcess.getOutputStream().flush();
        if (this.slangStreamReader.read() != WrappedSLANGTool.StreamDelimiter.SLANG_OPERATION_STARTED) {
            throw new IOException("Operation start signal was not received.");
        }
        if (this.slangStreamReader.read() != WrappedSLANGTool.StreamDelimiter.SLANG_OPERATION_ENDED) {
            throw new IOException("Operation end signal was not received. Output: " + this.slangStreamReader.getLastBuffer().toString());
        }
        return this.convertToSLResponse(this.slangStreamReader.getLastBuffer());
    }

    private SLResponse convertToSLResponse(StringBuilder buffer) {
        int pos = this.getMinPos(buffer.indexOf("\nERROR: "), buffer.indexOf(ParsingException.INVALID_OPERATION_SYNTAX));
        return new SLResponse(buffer.substring((pos = this.getMinPos(pos, buffer.indexOf("Syntax Error: "))) == -1 ? 0 : pos), pos == -1);
    }

    private int getMinPos(int pos1, int pos2) {
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    protected void close() {
        if (this.slangStreamReader != null) {
            try {
                this.slangStreamReader.close();
            }
            catch (IOException exception) {
                Trace.logError(this, "Failed to close slang stream reader. Cause: " + exception.toString());
            }
        }
        if (this.slangProcess != null) {
            try {
                this.slangProcess.destroy();
                this.slangProcess.waitFor();
            }
            catch (InterruptedException exception) {
                Trace.logError(this, "Failed to destroy slang process. Cause: " + exception.toString());
            }
            finally {
                this.slangProcess = null;
            }
        }
        if (this.closeChildThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.closeChildThread);
            this.closeChildThread = null;
        }
    }

    private void checkSlangProcessStatus() throws IOException {
        if (this.slangProcess == null) {
            throw new IOException("Slang tool process is not running.");
        }
        try {
            this.slangProcess.getOutputStream().write("__FAKE_CHECK_STATUS_OPERATION__".getBytes());
            this.slangProcess.getOutputStream().write("\n".getBytes());
            this.slangProcess.getOutputStream().flush();
        }
        catch (IOException exception) {
            Trace.logError(this, "SLANG tool check status failed. Cause: " + exception.getMessage());
            Trace.logError(this, "Last output: " + this.slangStreamReader.getLastBuffer().toString());
            this.close();
            throw new IOException("SLANG tool process is not running.");
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
    }

    public String getPlatformLibPath() {
        return this.platformLibPath;
    }

    public void setPlatformLibPath(String platformLibPath) {
        this.platformLibPath = platformLibPath;
    }

    public String getSlangJar() {
        return this.slangJar;
    }

    public void setSlangJar(String slangJar) {
        this.slangJar = slangJar;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    private class StreamReader {
        private BufferedReader inputReader;
        private StringBuilder lastBuffer;

        StreamReader() {
            this.resetLastBuffer();
            this.inputReader = new BufferedReader(new InputStreamReader(SLANGToolWrapper.this.slangProcess.getInputStream()));
        }

        void resetLastBuffer() {
            this.lastBuffer = new StringBuilder();
        }

        StringBuilder getLastBuffer() {
            return this.lastBuffer;
        }

        void close() throws IOException {
            this.inputReader.close();
        }

        void skipAll() throws IOException {
            while (this.inputReader.ready()) {
                this.inputReader.skip(1000L);
            }
        }

        WrappedSLANGTool.StreamDelimiter read() throws IOException {
            return this.read(-1L);
        }

        WrappedSLANGTool.StreamDelimiter read(long timeout) throws IOException {
            WrappedSLANGTool.StreamDelimiter delimiter = WrappedSLANGTool.StreamDelimiter.NO_DELIMITER;
            if (timeout == -1L) {
                timeout = Long.MAX_VALUE;
            }
            while (true) {
                String newLine;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < timeout && !this.inputReader.ready()) {
                    SLANGToolWrapper.this.checkSlangProcessStatus();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.inputReader.ready() || (delimiter = WrappedSLANGTool.StreamDelimiter.parse(newLine = this.inputReader.readLine())) != WrappedSLANGTool.StreamDelimiter.NO_DELIMITER) break;
                this.lastBuffer.append(newLine).append("\n");
            }
            return delimiter;
        }
    }

    private class CloseChildThread
    extends Thread {
        private CloseChildThread() {
        }

        @Override
        public void run() {
            if (SLANGToolWrapper.this.slangProcess != null) {
                SLANGToolWrapper.this.slangProcess.destroy();
            }
        }
    }
}

