/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathManager;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.console.Console;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.JavaDebugConsole;
import com.streamscape.tools.console.JavaReleaseConsole;
import com.streamscape.tools.console.NativeConsole;
import com.streamscape.tools.console.autocompletion.AutoCompletionConsole;
import com.streamscape.tools.console.terminal.DllLoaderException;
import com.streamscape.tools.console.terminal.LinuxTerminal;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.console.terminal.SttySettings;
import com.streamscape.tools.console.terminal.WindowsNativeLibrary;
import com.streamscape.tools.console.terminal.WindowsTerminal;
import com.streamscape.tools.slang.AlterDdxOperation;
import com.streamscape.tools.slang.DescribeClientOperation;
import com.streamscape.tools.slang.DescribeDdxOperation;
import com.streamscape.tools.slang.ListConsumersOperation;
import com.streamscape.tools.slang.SLANGToolDSLProvider;
import com.streamscape.tools.slang.SlangConsoleFromFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SLANGTool
extends AbstractSLANGTool
implements SLCallable {
    private static LaunchMode launchMode;
    private static boolean isLogEnabled;
    private static boolean javaConsole;
    private static boolean cygwin;
    private static String shellPath;
    private static String tty;
    private static InputStream sourceInputStream;
    private static boolean nointonfail;
    private long sessionTimeout = 0L;
    private List<DiscoveryLink> discoveryLinks;
    protected Map<String, ConsoleConsumer> consumers = new HashMap<String, ConsoleConsumer>();

    public static void main(String[] args) throws Exception {
        try {
            ConsoleConfiguration.initializeFromFile();
            ConsoleConfiguration.instance().setSaveToFile(false);
            SLANGTool.parseArgs(args);
            switch (launchMode.ordinal()) {
                case 0: {
                    SLANGTool.printUsage();
                    break;
                }
                case 1: {
                    SLANGTool.showVersion();
                    break;
                }
                case 2: {
                    ConsoleConfiguration.instance().setSaveToFile(true);
                    ConsoleConfiguration.instance().initializeParameters();
                    Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> ConsoleConfiguration.instance().saveToFile(), 10L, 10L, TimeUnit.SECONDS);
                    new SLANGTool().run();
                    break;
                }
                case 3: {
                    ConsoleConfiguration.instance().setSaveToFile(false);
                    ConsoleConfiguration.instance().initializeParameters();
                    new SLANGTool().run();
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(SLANGTool.class, exception, true);
            System.err.println("ERROR: " + SLANGTool.formatException(exception));
        }
    }

    static void parseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (arg.equals("-h") || arg.equals("-help")) {
                SLANGTool.checkLaunchMode();
                launchMode = LaunchMode.HELP;
                break;
            }
            if (arg.equals("-version")) {
                SLANGTool.checkLaunchMode();
                launchMode = LaunchMode.VERSION;
                break;
            }
            if (arg.equals("-log")) {
                if (isLogEnabled) {
                    SLANGTool.exit("Parsing error: several '-log' parameters specified.");
                }
                TraceConfigurator.getInstance().enableLog(new ContainerLogger(i + 1 < args.length && !args[i + 1].startsWith("-") ? args[++i] : "slang.log", "slang.log", false));
                TraceConfigurator.getInstance().init(false);
                TraceConfigurator.getInstance().enable("(*) debug");
                Trace.setLogger("*", TraceConfigurator.getInstance().getLogger());
                isLogEnabled = true;
                continue;
            }
            if (arg.equals("-url")) {
                if (url != null) {
                    SLANGTool.exit("several '-url' parameters specified.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-url' parameter missed.");
                }
                url = args[i];
                continue;
            }
            if (arg.equals("-u")) {
                if (userName != null) {
                    SLANGTool.exit("several '-u' parameters specified.");
                }
                if (securityToken != null) {
                    SLANGTool.exit("parameters '-u' and '-key' cannot be specified simultaneously.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-u' parameter missed.");
                }
                userName = args[i];
                continue;
            }
            if (arg.equals("-p")) {
                if (password != null) {
                    SLANGTool.exit("several '-p' parameters specified.");
                }
                if (securityToken != null) {
                    SLANGTool.exit("parameters '-p' and '-key' cannot be specified simultaneously.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-p' parameter missed.");
                }
                password = args[i];
                continue;
            }
            if (arg.equals("-key")) {
                if (securityToken != null) {
                    SLANGTool.exit("several '-key' parameters specified.");
                }
                if (userName != null) {
                    SLANGTool.exit("parameters '-u' and '-key' cannot be specified simultaneously.");
                }
                if (password != null) {
                    SLANGTool.exit("parameters '-p' and '-key' cannot be specified simultaneously.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-key' parameter missed.");
                }
                securityToken = args[i];
                continue;
            }
            if (arg.equals("-timeout")) {
                if (timeout != null) {
                    SLANGTool.exit("several '-timeout' parameters specified.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-timeout' parameter missed.");
                }
                try {
                    timeout = Long.parseLong(args[i]);
                }
                catch (NumberFormatException exception) {
                    SLANGTool.exit("value of '-timeout' parameter has wrong format.");
                }
                if (timeout > 0L) continue;
                SLANGTool.exit("value of '-timeout' parameter must be positive.");
                continue;
            }
            if (arg.equals("-r") || arg.equals("-reliable")) {
                isReliable = true;
                continue;
            }
            if (arg.equals("-s") || arg.equals("-ssl")) {
                isSSL = true;
                continue;
            }
            if (arg.equals("-d") || arg.equals("-diag") || arg.equals("-diagnostic")) {
                sessionType = AbstractSLANGTool.SessionType.DIAGNOSTIC;
                continue;
            }
            if (arg.equals("-a") || arg.equals("-activator")) {
                sessionType = AbstractSLANGTool.SessionType.ACTIVATOR;
                continue;
            }
            if (arg.equals("-noprompt")) {
                noPrompt = true;
                continue;
            }
            if (arg.equals("-no-version") || arg.equalsIgnoreCase("-noversion")) {
                noVersion = true;
                continue;
            }
            if (arg.equals("-java-console")) {
                javaConsole = true;
                continue;
            }
            if (arg.equals("-nocolor")) {
                ConsoleConfiguration.instance().setMonochrome(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-cygwin")) {
                cygwin = true;
                continue;
            }
            if (arg.equals("-shellpath")) {
                if (shellPath != null) {
                    SLANGTool.exit("several '-shellpath' parameters specified.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-shellpath' parameter missed.");
                }
                shellPath = args[i];
                continue;
            }
            if (arg.equals("-tty")) {
                if (tty != null) {
                    SLANGTool.exit("several '-tty' parameters specified.");
                }
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-tty' parameter missed.");
                }
                tty = args[i];
                continue;
            }
            if (arg.equals("-delimiter")) {
                String delimiter;
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-delimiter' parameter is missing.");
                }
                if ((delimiter = args[i].trim()).length() == 0) {
                    delimiter = "\n";
                }
                ConsoleConfiguration.instance().setDelimiter(delimiter);
                continue;
            }
            if (arg.equals("-file")) {
                String filename;
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-file' parameter is missing.");
                }
                javaConsole = true;
                launchMode = LaunchMode.FROM_SOURCE;
                if (sourceInputStream != null) {
                    SLANGTool.exit("file or commands already specified.");
                }
                if (!new File(filename = args[i]).exists()) {
                    SLANGTool.exit("file '" + filename + "' does not exist.");
                }
                sourceInputStream = new FileInputStream(filename);
                continue;
            }
            if (arg.equals("-commands")) {
                if (++i >= args.length) {
                    SLANGTool.exit("value of '-commands' parameter is missing.");
                }
                javaConsole = true;
                launchMode = LaunchMode.FROM_SOURCE;
                if (sourceInputStream != null) {
                    SLANGTool.exit("file or commands already specified.");
                }
                sourceInputStream = new ByteArrayInputStream(SLANGTool.replaceNewLines(args[i]).getBytes());
                continue;
            }
            if (arg.equals("-nointonfail")) {
                nointonfail = true;
                continue;
            }
            SLANGTool.exit("invalid parameter '" + arg + "'.");
        }
        if (userName == null && password != null) {
            SLANGTool.exit("parameter '-p' cannot be specified without '-u'.");
        }
        if (launchMode == null) {
            launchMode = LaunchMode.RUN;
        }
    }

    private static String replaceNewLines(String commands) {
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < commands.length(); ++j) {
            char c = commands.charAt(j);
            if (c == '\\' && j + 1 < commands.length()) {
                if ((c = commands.charAt(++j)) == '\\') {
                    builder.append("\\");
                    continue;
                }
                if (c == 'r') {
                    builder.append("\r");
                    continue;
                }
                if (c == 'n') {
                    builder.append("\n");
                    continue;
                }
                builder.append("\\").append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static void checkLaunchMode() {
        if (launchMode != null) {
            SLANGTool.exit("only one of parameters '-help' or '-version' must be specified.");
        }
    }

    static void printUsage() {
        System.out.println("\n    TruFabric Semantic Language Tool\n");
        System.out.println("    " + com.streamscape.tools.slang.Version.getVersionString() + " (Fabric Runtime " + Version.getVersion() + ")\n    Copyright (c) 2015-2025 StreamScape Technologies\n");
        System.out.println("    Usage: slang [ -version ]\n\n                 [ -dir <working_directory> ]\n                 [ -java-cfg <jvm_options_filename> ]\n                 [ -java-args \"<jvm_options>\" ]\n                 [ -java-home <java_home_directory> ]\n                 [ -url <url> ]\n                 [ -u <user_name> ]\n                 [ -p <user_password> ]\n                 [ -key <security_token> ]\n                 [ -timeout <timeout> ]\n                 [ -r | -reliable ]\n                 [ -s | -ssl ]\n                 [ -d | -diag | -diagnostic ]\n                 [ -a | -activator ]\n                 [ -noprompt ]\n                 [ -noversion ]\n                 [ -delimiter <delimiter> ]\n                 [ -file <file_path> ]\n                 [ -commands <list_of_commands> ]\n                 [ -nointonfail ]\n                 [ -java-console ]\n                 [ -nocolor ]\n                 [ -cygwin ]\n                 [ -shellpath <path>]\n                 [ -tty ]\n                 [ -debug ]\n                 [ -h | -help ]\n");
        System.out.println("    -version       Displays version information.\n");
        System.out.println("    -dir           Working directory of the tool.\n                   Default is the current directory. Values containing spaces must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
        System.out.println("    -java-cfg      Path to the file containing JVM options.\n                   Default is slang.conf. Values containing spaces must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
        System.out.println("    -java-args     List of JVM options (e.g. \"-Xmx256m\"). Options must be quoted.\n                   This parameter is only supported when used with a platform-specific launcher.\n");
        System.out.println("    -java-home     Path to Java Home directory (e.g. \"C:/Program Files/Java/jre8\").\n                   If this parameter is not specified, $STROOT/platform/jre is checked at first.\n                   If it is absent then a standard Java installation will be searched.\n                   $JAVA_HOME is used first and then the registry is used on the Windows platform.\n                   This parameter is only supported when used with a platform-specific launcher.\n                   Values containing spaces must be quoted.\n");
        System.out.println("    -log           Allows the tool to write trace messages to a specified log file.\n                   Default is slang.log. Values containing spaces must be quoted.\n");
        System.out.println("    -url           URL used for connecting to Fabric node on startup.\n");
        System.out.println("    -u             User name used for connecting to Fabric node on startup.\n                   This parameter will be used only if -url parameter is specified.\n");
        System.out.println("    -p             User password used for connecting to Fabric node on startup.\n                   This parameter will be used only if -url parameter is specified.\n");
        System.out.println("    -key           Security token for connecting to Fabric node on startup.\n                   This parameter will be used only if -url parameter is specified.\n                   Parameters -key and -u/-p are mutually exclusive.\n");
        System.out.println("    -timeout       Time (in seconds) of waiting for connection establishment.\n                   Default is 10 seconds. This parameter is used only if -url option is specified.\n");
        System.out.println("    -reliable      Allows to restore session after connection break.\n    -r             This option is used only if -url option is specified.\n                   This option is not applicable to Diagnostic or Activator session.\n");
        System.out.println("    -ssl           Allows to establish SSL connection.\n    -s\n");
        System.out.println("    -diag          Creates a diagnostic session to the Fabric at start-up.\n    -diagnostic    This option is used only only if -url parameter is specified.\n");
        System.out.println("    -noprompt      Disables a printing of the prompts.\n");
        System.out.println("    -noversion     Disables a printing of the version information.\n");
        System.out.println("    -delimiter     Specifies a line delimiter. Empty delimiter means a new line.\n                   In Linux the value should be quoted in several cases (e.g. -delimiter '#').\n");
        System.out.println("    -file          Path to the file containing a list of commands to be executed.\n                   Values containing spaces must be quoted.\n                   Execution will be interrupted on a first failed command (if '-nointonfail' option not specified).\n");
        System.out.println("    -commands      List of commands to be executed.\n                   Commands should be delimited by the specified delimiter (default is a new line).\n                   Execution will be interrupted on a first failed command (if '-nointonfail' option not specified).\n");
        System.out.println("    -nointonfail   Allows to not interrupt execution of the command list if any command failed.\n                   This parameter should be used with -file or -commands options.\n");
        System.out.println("    -java-console  Uses a standard Java console.\n");
        System.out.println("    -nocolor       Uses a monochrome console.\n");
        System.out.println("    -cygwin        Works in Cygwin mode (uses a specific version of a console).\n");
        System.out.println("    -shellpath     Path to sh.exe for Cygwin mode. Values containing spaces must be quoted.\n");
        System.out.println("    -tty           Parameter tty for Cygwin mode.\n");
        System.out.println("    -debug         Prints launcher debug information to a debug.log file.\n");
        System.out.println("    -h             Displays help information.\n    -help");
    }

    static void exit(String message) {
        System.err.println("\nParsing error: " + message);
        SLANGTool.printUsage();
        SLANGTool.closeSourceInputStream();
        System.exit(1);
    }

    static void closeSourceInputStream() {
        if (sourceInputStream != null) {
            try {
                sourceInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    SLANGTool() throws IOException {
        this.slangProvider = new SLANGToolDSLProvider(this);
        this.console = this.createConsole();
        this.console.setPrompt(this.getPrompt());
        this.console.setNoPrompt(noPrompt);
        if (this.console instanceof AutoCompletionConsole) {
            ((AutoCompletionConsole)this.console).addCompleter(this.slangProvider);
        }
    }

    protected ClientContext getContext() {
        return this.context;
    }

    protected FabricConnection getConnection() {
        return this.connection;
    }

    protected String getNodeName() {
        return this.connection.nodeName;
    }

    @Override
    protected boolean isAnonymous() {
        return super.isAnonymous();
    }

    List<DiscoveryLink> getDiscoveryLinks(String nodeName) {
        ArrayList<DiscoveryLink> result = new ArrayList<DiscoveryLink>();
        if (this.discoveryLinks != null) {
            result.addAll(this.discoveryLinks.stream().filter(link -> link.getNodeName().equals(nodeName)).collect(Collectors.toList()));
        }
        return result;
    }

    void setDiscoveryLinks(List<DiscoveryLink> discoveryLinks) {
        this.discoveryLinks = discoveryLinks;
    }

    @Override
    protected void exit() {
        SLANGTool.closeSourceInputStream();
        super.exit();
    }

    @Override
    protected AbstractSLANGTool.ConnectResult connect(String url, String userName, String password, long timeout, boolean reliable, Boolean ssl, AbstractSLANGTool.SessionType sessionType) {
        return super.connect(url, userName, password, timeout, reliable, ssl, sessionType);
    }

    @Override
    protected void reconnect(long timeout, boolean reliable, Boolean ssl, AbstractSLANGTool.SessionType sessionType) {
        super.reconnect(timeout, reliable, ssl, sessionType);
    }

    @Override
    protected void disconnect() {
        super.disconnect();
    }

    protected boolean isConnected() {
        return this.isConnected;
    }

    @Override
    protected boolean isSpecial() {
        return super.isSpecial();
    }

    protected String getURL() {
        return url;
    }

    @Override
    protected String getUserName() {
        return super.getUserName();
    }

    @Override
    protected void addURL(String url) throws Exception {
        super.addURL(url);
    }

    @Override
    protected void removeURL(String url) {
        super.removeURL(url);
    }

    @Override
    protected void setReconnectAttempts(int reconnectAttempts) {
        super.setReconnectAttempts(reconnectAttempts);
    }

    @Override
    protected void setReconnectInterval(long reconnectInterval) throws Exception {
        super.setReconnectInterval(reconnectInterval);
    }

    @Override
    protected SLResponse invokeSessionRequest(String request) throws SLSessionException {
        return super.invokeSessionRequest(request);
    }

    @Override
    protected SLResponse invokeSessionRequest(SLStatement request) throws SLSessionException {
        return super.invokeSessionRequest(request);
    }

    public SLResponse invokeConsoleCommand(String command) {
        return this.console.invokeConsoleCommand(command);
    }

    protected int getMaxColumnWidth() {
        return this.rowSetPrinter.getMaxColumnWidth();
    }

    protected void setMaxColumnWidth(int width) {
        this.rowSetPrinter.setMaxColumnWidth(width);
    }

    protected void setStatsTimeOn(boolean statsTimeOn) {
        ConsoleConfiguration.instance().setStatsTimeOn(statsTimeOn);
    }

    protected void setNoHeader(boolean noHeader) {
        this.rowSetPrinter.setSuppressHeader(noHeader);
    }

    protected boolean getNoHeader() {
        return this.rowSetPrinter.isSuppressHeader();
    }

    @Override
    protected long getReplyTimeout() {
        return ConsoleConfiguration.instance().getReplyTimeout();
    }

    @Override
    protected void setReplyTimeout(long replyTimeout) {
        ConsoleConfiguration.instance().setReplyTimeout(replyTimeout);
    }

    protected void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    protected long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    protected boolean isBasicPrompt() {
        return ConsoleConfiguration.instance().isBasicPrompt();
    }

    @Override
    protected void setBasicPrompt(boolean basicPrompt) {
        ConsoleConfiguration.instance().setBasicPrompt(basicPrompt);
        this.setPrompt(this.promptSLResponse);
    }

    @Override
    public boolean isDiscoveryMulticastEnabled() {
        return ConsoleConfiguration.instance().isDiscoveryMulticastEnabled();
    }

    @Override
    public void setDiscoveryFabricDirectory(String discoveryFabricDirectory) {
        ConsoleConfiguration.instance().setDiscoveryFabricDirectory(discoveryFabricDirectory);
    }

    @Override
    public String getDiscoveryFabricDirectory() {
        return ConsoleConfiguration.instance().getDiscoveryFabricDirectory();
    }

    @Override
    public void setDiscoveryMulticastEnabled(boolean discoveryMulticastEnabled) {
        ConsoleConfiguration.instance().setDiscoveryMulticastEnabled(discoveryMulticastEnabled);
    }

    @Override
    public String getDiscoveryMulticastAddress() {
        return ConsoleConfiguration.instance().getDiscoveryMulticastAddress();
    }

    @Override
    public void setDiscoveryMulticastAddress(String discoveryMulticastAddress) {
        ConsoleConfiguration.instance().setDiscoveryMulticastAddress(discoveryMulticastAddress);
    }

    @Override
    public long getDiscoveryMulticastWaitingTime() {
        return ConsoleConfiguration.instance().getDiscoveryMulticastWaitingTime();
    }

    @Override
    public void setDiscoveryMulticastWaitingTime(long discoveryMulticastWaitingTime) {
        ConsoleConfiguration.instance().setDiscoveryMulticastWaitingTime(discoveryMulticastWaitingTime);
    }

    @Override
    protected void fillSessionInfo(RowSet result) throws Exception {
        super.fillSessionInfo(result);
    }

    @Override
    protected Console createConsole() {
        if (sourceInputStream != null) {
            return new SlangConsoleFromFile(sourceInputStream);
        }
        if (!javaConsole) {
            if (cygwin) {
                if (shellPath == null || tty == null) {
                    System.out.println("ERROR: Cygwin shell path or tty not specified.");
                    System.exit(-1);
                }
                SttySettings sttySettings = new SttySettings(false);
                sttySettings.setSHCommand(shellPath);
                sttySettings.setTty(tty);
                LinuxTerminal terminal = new LinuxTerminal(sttySettings);
                try {
                    terminal.init();
                }
                catch (Exception exception) {
                    System.out.println("Initializing Cygwin native console failed. Cause: " + exception.toString());
                    System.out.println("Using java debug console...");
                    return new JavaDebugConsole();
                }
                return new NativeConsole(terminal);
            }
            if (JVM.isWindowsOS()) {
                try {
                    try {
                        WindowsNativeLibrary.init();
                    }
                    catch (DllLoaderException exception) {
                        Trace.logException(this, exception, false);
                        Trace.logDebug(this, "Loading WindowsNativeLibrary from jar failed.");
                        WindowsNativeLibrary.init("../tools/WindowsNativeLibrary/Release/x64/WindowsNativeLibrary.dll");
                    }
                    return new NativeConsole(new WindowsTerminal(true));
                }
                catch (DllLoaderException exception) {
                    Trace.logDebug(this, "Loading WindowsNativeLibrary failed.");
                }
            } else {
                SttySettings sttySettings = new SttySettings(true);
                if (shellPath != null) {
                    sttySettings.setSHCommand(shellPath);
                }
                if (tty != null) {
                    sttySettings.setTty(tty);
                }
                LinuxTerminal terminal = new LinuxTerminal(sttySettings);
                try {
                    terminal.init();
                    return new NativeConsole(terminal);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Initializing Linux terminal failed.");
                    Trace.logException(this, exception, true);
                }
            }
        }
        return System.console() != null ? new JavaReleaseConsole(System.console()) : new JavaDebugConsole();
    }

    protected boolean isNativeConsole() {
        return this.console instanceof NativeConsole;
    }

    @Override
    protected String getPrompt() {
        return !noPrompt ? this.prompt : "";
    }

    @Override
    protected void showPrompt() {
        if (!noPrompt) {
            this.console.getPrintStream().print(this.prompt);
        }
    }

    @Override
    protected void doSetPrompt(String prompt, boolean isRouted) {
        super.doSetPrompt(!noPrompt ? prompt : "", isRouted);
    }

    @Override
    protected void println(String line) {
        super.println(line);
    }

    @Override
    protected void logException(Throwable exception) {
        Trace.logException(SLANGTool.class, exception, true);
    }

    @Override
    protected void onCommandFail() {
        if (launchMode == LaunchMode.FROM_SOURCE && !nointonfail) {
            this.exit();
        }
    }

    protected String readPassword(String prompt) throws ReadInterruptedException {
        return this.console.readPassword(prompt);
    }

    public void setNoPrompt(boolean noPrompt) {
        this.console.setNoPrompt(noPrompt);
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    @Override
    protected boolean isDuplicateOperation(Operation operation) {
        return operation instanceof ListConsumersOperation || operation instanceof DescribeClientOperation || this.isConnected() && (operation instanceof AlterDdxOperation || operation instanceof DescribeDdxOperation);
    }

    synchronized void addConsumer(String name, boolean async, String eventId, String selector, EventScope scope, List<ConsumerAction> actions, boolean start) throws Exception {
        if (this.connection == null) {
            throw new FabricException("SLANG tool is not connected to sysplex.");
        }
        if (!this.context.getDatagramPrototypeCache().existsEventId(eventId)) {
            this.connection.importEventPrototype(eventId);
        }
        Pair<Prototype, ImmutableEventDatagram> event = this.getPrototype(eventId);
        for (ConsumerAction action : actions) {
            action.validate((ImmutableEventDatagram)event.second);
        }
        ConsoleConsumer consumer = new ConsoleConsumer(name, async, eventId, selector, scope, actions, start);
        this.consumers.put(name, consumer);
        if (start) {
            this.doStartConsumer(consumer);
        }
    }

    synchronized void removeConsumer(String name) throws Exception {
        if (this.consumers.remove(name) == null) {
            throw new FabricException("Consumer not found.");
        }
        this.connection.dropConsumer(name);
    }

    synchronized ConsoleConsumer getConsumer(String name) throws Exception {
        ConsoleConsumer result = this.doGetConsumer(name);
        if (result == null) {
            throw new FabricException("Consumer not found.");
        }
        return result;
    }

    synchronized List<ConsoleConsumer> getConsumers() {
        return new ArrayList<ConsoleConsumer>(this.consumers.values());
    }

    synchronized boolean startConsumer(String name) throws Exception {
        ConsoleConsumer cc = this.doGetConsumer(name);
        if (cc.isStarted) {
            throw new FabricException("Consumer already started.");
        }
        this.doStartConsumer(cc);
        return cc.async;
    }

    synchronized void doStartConsumer(ConsoleConsumer cc) throws Exception {
        EventAsyncConsumer consumer = this.connection.createEventAsyncConsumer(cc.name, new ConsumerListener(cc.actions), cc.eventId, cc.eventSelector, cc.eventScope, true);
        consumer.start();
        cc.isStarted = true;
        if (!cc.async) {
            this.showInterruptMessageForASyncCommand();
        }
    }

    static String getAsyncConsumerMessage() {
        return "\nOperation started in background. Use Ctrl+C to terminate the SLANG application.\nAll client operations will terminate on application exit.\n";
    }

    synchronized void stopConsumer(String name) throws Exception {
        ConsoleConsumer cc = this.doGetConsumer(name);
        if (!cc.isStarted) {
            throw new FabricException("Consumer not started.");
        }
        try {
            this.connection.dropConsumer(name);
        }
        catch (Throwable exception) {
            this.logException(exception);
        }
        cc.isStarted = false;
    }

    private ConsoleConsumer doGetConsumer(String name) throws Exception {
        ConsoleConsumer result = this.consumers.get(name);
        if (result == null) {
            throw new FabricException("Consumer not found.");
        }
        return result;
    }

    @Override
    public void setConsoleCCSID(Charset ccsid) throws UnsupportedEncodingException {
        if (JVM.isWindowsOS() && ccsid != null) {
            try {
                WindowsNativeLibrary.setCodePage(ccsid.name());
                this.console.setEncoding(Charset.forName(ccsid.name()));
            }
            catch (Throwable e) {
                this.logException(e);
            }
        }
    }

    static {
        isLogEnabled = false;
        javaConsole = false;
        cygwin = false;
        nointonfail = false;
    }

    private static enum LaunchMode {
        HELP,
        VERSION,
        RUN,
        FROM_SOURCE;

    }

    static abstract class ConsumerAction {
        String statement;

        ConsumerAction(String statement) {
            this.statement = statement;
        }

        void validate(ImmutableEventDatagram event) throws Exception {
        }

        abstract void execute(ImmutableEventDatagram var1);

        public String toString() {
            return this.statement;
        }
    }

    static class ConsoleConsumer {
        String name;
        boolean async;
        String eventId;
        String eventSelector;
        EventScope eventScope;
        List<ConsumerAction> actions;
        boolean isStarted = false;

        ConsoleConsumer(String name, boolean async, String eventId, String eventSelector, EventScope eventScope, List<ConsumerAction> actions, boolean isStarted) {
            this.name = name;
            this.async = async;
            this.eventId = eventId;
            this.eventSelector = eventSelector;
            this.eventScope = eventScope;
            this.actions = actions;
            this.isStarted = isStarted;
        }
    }

    private static class ConsumerListener
    implements FabricEventListener {
        List<ConsumerAction> actions;

        ConsumerListener(List<ConsumerAction> actions) {
            this.actions = actions;
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            this.actions.forEach(action -> action.execute(event));
        }
    }

    class PrintEventAction
    extends ConsumerAction {
        String sdrPath;

        PrintEventAction(String statement, String sdrPath) {
            super(statement);
            this.sdrPath = sdrPath;
        }

        @Override
        void validate(ImmutableEventDatagram event) throws Exception {
            if (this.sdrPath != null) {
                ReferencePathManager manager = SLANGTool.this.getContext().getSDRManagerFactory().createManager();
                manager.getValueAtPath(this.sdrPath, event);
            }
        }

        @Override
        void execute(ImmutableEventDatagram event) {
            try {
                if (this.sdrPath == null) {
                    SLANGTool.this.println(SLANGTool.this.context.getJSONSerializer().withPrettyPrint(true).serialize(event));
                } else {
                    ReferencePathManager manager = SLANGTool.this.getContext().getSDRManagerFactory().createManager();
                    SLANGTool.this.println(String.valueOf(manager.getValueAtPath(this.sdrPath, event)));
                }
            }
            catch (Throwable exception) {
                SLANGTool.this.printError(SLANGTool.formatException(exception));
            }
        }
    }

    class PrintTextAction
    extends ConsumerAction {
        String text;

        PrintTextAction(String statement, String text) {
            super(statement);
            this.text = text;
        }

        @Override
        void execute(ImmutableEventDatagram event) {
            SLANGTool.this.println(this.text);
        }
    }
}

