/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class ReconnectOperation
extends AbstractSessionOperation {
    private static final String NAME = "reconnect";

    public ReconnectOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RECONNECT");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TIMEOUT", false).addParameter(new IntegerParameter("Timeout").setRange(1, Integer.MAX_VALUE))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("RELIABLE", false).setAlias("R"));
        this.syntax.addModifier((AbstractModifier)new Modifier("SSL", false).setAlias("S"));
        this.syntax.addModifier(((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("DIAGNOSTIC").setAlias("DIAG"))).addPossibleValue("ACTIVATOR"));
        this.syntax.setDescription("Reconnects to the sysplex using URL of the latest session.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   timeout <Timeout> - Time (in seconds) of waiting for connection establishment.\n                       Default is 10 seconds.\n   reliable          - Allows the tool to restore session after connection break.\n                       This parameter is not applicable to Diagnostic or Activator sessions.\n   ssl               - Allows to establish SSL connection.\n   diagnostic        - Opens a diagnostic session to the sysplex using URL of the latest session.\n   activator         - Opens a session to the Activator using using URL of the latest session.");
        this.syntax.setExamples("reconnect\nreconnect diagnostic\nreconnect activator\nreconnect timeout 5\nreconnect reliable\nreconnect timeout 5 reliable");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return ((SLANGTool)this.callable).getURL() != null;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((SLANGTool)this.callable).reconnect(definition.timeout, definition.reliable, definition.ssl, definition.sessionType);
        return new AbstractSLANGTool.IgnoredResponse();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition();
        if (statement.existsParameter("Timeout")) {
            definition.setTimeout(Integer.parseInt(statement.getParameter("Timeout").getValue()));
        }
        if (statement.existsModifier("RELIABLE")) {
            definition.setReliable(true);
        }
        if (statement.existsModifier("SSL")) {
            definition.setSSL(true);
        }
        if (statement.existsModifier("DIAGNOSTIC")) {
            definition.setSessionType(AbstractSLANGTool.SessionType.DIAGNOSTIC);
        }
        if (statement.existsModifier("ACTIVATOR")) {
            definition.setSessionType(AbstractSLANGTool.SessionType.ACTIVATOR);
        }
        return definition;
    }

    static class Definition
    extends AbstractSLStatement {
        private int timeout = -1;
        private boolean reliable = false;
        private Boolean ssl = null;
        private AbstractSLANGTool.SessionType sessionType = AbstractSLANGTool.SessionType.STANDARD;

        Definition() {
            super(ReconnectOperation.NAME);
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        void setReliable(boolean reliable) {
            this.reliable = reliable;
        }

        void setSSL(boolean ssl) {
            this.ssl = ssl;
        }

        void setSessionType(AbstractSLANGTool.SessionType sessionType) {
            this.sessionType = sessionType;
        }
    }
}

