/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.cli.tlp.PingState;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;

class PingNodeOperation
extends AbstractSessionOperation {
    private static final String NAME = "ping node";

    PingNodeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("PING NODE").addActionParameter(new ExpressionParameter("url"));
        this.syntax.setDescription("Checks if a node specified by the URL is available for communication.\nOne of the following states can be returned:\n  AVAILABLE                  - Node is running and available for communication.\n  AVAILABLE_VERSION_MISMATCH - Node is running, but the tool version does not match the node version.\n  UNAVAILABLE                - Node is not available for communication (probably, not running).\n  INITIALIZING               - Node is running, but its initialization is still not completed.\n                               The following initialization stages are possible:\n                                 1300 - Global Variable Factory.\n                                 1301 - Security Manager.\n                                 1302 - Serial Schemas.\n                                 1303 - Runtime Package Manifest.\n                                 1304 - Custom Semantic Types.\n                                 1305 - Datagram Factories.\n                                 1306 - Type Analyzer Factory.\n                                 1307 - Discovery Module.\n                                 1308 - Acceptor Factories.\n                                 1309 - Fabric Exchange.\n                                 1310 - Fabric Exchange starting.\n                                 1311 - Admin HTTP Acceptor.\n                                 1312 - Runtime Event Dispatcher.\n                                 1313 - TLP Acceptors starting.\n                                 1314 - Log Event Sender.\n                                 1400 - Event Identity Plugins.\n                                 1401 - Converter Plugins.\n                                 1402 - Drop Box Manager.\n                                 1403 - Drop Box Manager Remote.\n                                 1404 - Dataspace Manager.\n                                 1405 - Drop Box paths validation.\n                                 1406 - HTTP Authentication Manager.\n                                 1407 - DSL Processor.\n                                 1408 - Runtime Session Manager.\n                                 1409 - Security Manager completion.\n                                 1410 - Coherence Agent.\n                                 1411 - Security Key Store.\n                                 1412 - Scheduler.\n                                 1413 - Join Sysplex.\n                                 1414 - Dataspace Manager opening.\n                                 1415 - Scheduler recovery.\n                                 1416 - Service Manager.\n                                 1417 - Acceptors starting.\n                                 1418 - Stats Monitor.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("url").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Object url = ((Definition)statement).url;
        if (!((String)url).contains("://")) {
            url = FabricConnection.URL_PREFIX + (String)url;
        }
        return new SLResponse(PingNodeOperation.format(new FabricConnectionFactory((String)url).createConnection().ping()));
    }

    private static RowSet format(PingResult result) {
        RowSet rowSet = new RowSet(PingNodeOperation.createResultDescriptor());
        PingNodeOperation.add(rowSet, new Object[]{"State", result.getState().name()});
        if (result.getState() != PingState.UNAVAILABLE) {
            PingNodeOperation.add(rowSet, new Object[]{"Node", result.getNodeName()});
            PingNodeOperation.add(rowSet, new Object[]{"Role", result.getRole()});
            PingNodeOperation.add(rowSet, new Object[]{"Version", result.getVersion()});
            PingNodeOperation.add(rowSet, new Object[]{"Domain", result.getDomain()});
            PingNodeOperation.add(rowSet, new Object[]{"Organizations", result.listOrganizations()});
            PingNodeOperation.add(rowSet, new Object[]{"Peer State", result.getPeerState()});
            PingNodeOperation.add(rowSet, new Object[]{"PID", result.getPid()});
            if (result.getState() == PingState.INITIALIZING) {
                PingNodeOperation.add(rowSet, new Object[]{"Initialization Stage", result.getInitStage()});
                if (result.getInitProperties() != null) {
                    PingNodeOperation.add(rowSet, new Object[]{"Initialization Properties", result.getInitProperties()});
                }
            }
        }
        return rowSet;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        PingNodeOperation.addColumn(result, "Property");
        PingNodeOperation.addColumn(result, "Value");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String url;

        Definition(String url) {
            super(PingNodeOperation.NAME);
            this.url = url;
        }
    }
}

