/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.operation.frm.AbstractFrmOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.runtime.mf.operation.frm.FrmFileWriter;
import com.streamscape.runtime.mf.operation.frm.FrmManifest;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LocalPathCompleter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.tools.slang.SLANGTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class MakeFrmOperation
extends AbstractFrmOperation<SLANGTool> {
    private static final String NAME = "make frm";

    MakeFrmOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MAKE FRM");
        CompoundModifier modifier = new CompoundModifier("AtModifier");
        modifier.addModifier(new ChoiceModifier("").addPossibleValue("AT").addPossibleValue("@"));
        modifier.addParameter(new LocalPathParameter("FrmPath"));
        modifier.setSyntaxHint(SyntaxHint.SPACE);
        this.syntax.addModifier(modifier);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("NODE").addParameter(new LocalPathParameter("NodeDir", LocalPathCompleter.PathScope.DIRECTORIES))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DDX", false).addParameter(new LocalPathParameter("DdxDir", LocalPathCompleter.PathScope.DIRECTORIES))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("MANIFEST").addParameter(new LocalPathParameter("ManifestPath"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)new Modifier("MNODE-SCRIPT", false).addParameter(new LocalPathParameter("MnodeScript")));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TNODE-SCRIPT", false).addParameter(new LocalPathParameter("TnodeScript"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Makes the Fabric Resource Module out of the specified node directory and based on specified manifest.");
        this.syntax.setExamples("make frm at 'C:/Streamscape/Node1.frm' node 'C:/Streamscape/Nodes/Node1' manifest 'C:/Streamscape/Node1.frmm'\n mnode-script 'c:/Streamscape/test.slang'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        String ddxDir = statement.existsParameter("DdxDir") ? statement.getParameter("DdxDir").getValue() : statement.getParameter("NodeDir").getValue();
        Definition definition = new Definition(statement.getParameter("FrmPath").getValue(), statement.getParameter("NodeDir").getValue(), ddxDir, statement.getParameter("ManifestPath").getValue());
        if (statement.existsParameter("MnodeScript")) {
            definition.setMnodeScript(statement.getParameter("MnodeScript").getValue());
        }
        if (statement.existsParameter("TnodeScript")) {
            definition.setTnodeScript(statement.getParameter("TnodeScript").getValue());
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        File nodeWorkingDir = new File(definition.getNodeDir());
        if (!nodeWorkingDir.exists()) {
            throw new IllegalArgumentException("Specified working dir does not exist.");
        }
        File ddxDir = new File(definition.getDdxDir());
        FrmManifest manifest = (FrmManifest)MakeFrmOperation.getSerializer().deserialize(FileIOUtils.getFileContent(new File(definition.getManifestPath())));
        this.addSemanticTypesByAncestor(nodeWorkingDir, manifest);
        this.addMlcacheEntities(nodeWorkingDir, manifest);
        FrmFileWriter frmFile = new FrmFileWriter(definition.getFrmPath());
        frmFile.addFile("manifest.frmm", MakeFrmOperation.getSerializer().serialize(manifest).getBytes());
        frmFile.generate(nodeWorkingDir, ddxDir, manifest, null);
        if (definition.getMnodeScript() != null) {
            frmFile.addFile("mnode.slang", FileIOUtils.getFileContent(new File(definition.getMnodeScript())));
        }
        if (definition.getTnodeScript() != null) {
            frmFile.addFile("tnode.slang", FileIOUtils.getFileContent(new File(definition.getTnodeScript())));
        }
        frmFile.close();
        return new SLResponse();
    }

    private void addSemanticTypesByAncestor(File workingDir, FrmManifest manifest) throws Exception {
        Set includeAncestors = ((Set)manifest.getIncludeEntities().getOrDefault((Object)FrmEntityType.SEMANTIC_TYPES_WITH_ANCESTOR, new HashSet())).stream().map(e -> e.getName()).collect(Collectors.toSet());
        Set excludeAncestors = ((Set)manifest.getExcludeEntities().getOrDefault((Object)FrmEntityType.SEMANTIC_TYPES_WITH_ANCESTOR, new HashSet())).stream().map(e -> e.getName()).collect(Collectors.toSet());
        if (includeAncestors.size() != 0 || excludeAncestors.size() != 0) {
            Set includeTypes = manifest.getIncludeEntities().getOrDefault((Object)FrmEntityType.SEMANTIC_TYPE, new HashSet());
            Set excludeTypes = manifest.getExcludeEntities().getOrDefault((Object)FrmEntityType.SEMANTIC_TYPE, new HashSet());
            for (File file : FileIOUtils.directoryList(FrmEntityType.SEMANTIC_TYPE.getDirectory(workingDir).getAbsolutePath(), "")) {
                SemanticType semanticType = (SemanticType)AbstractFrmOperation.getSerializer().deserialize(new String(Files.readAllBytes(file.toPath())));
                if (includeAncestors.contains("*") || includeAncestors.contains(semanticType.getAncestorType())) {
                    includeTypes.add(new FrmEntity(semanticType.getTypeName() + ".type", ""));
                    continue;
                }
                if (!excludeAncestors.contains("*") && !excludeAncestors.contains(semanticType.getAncestorType())) continue;
                excludeTypes.add(new FrmEntity(semanticType.getTypeName() + ".type", ""));
            }
            if (includeTypes.size() > 0) {
                manifest.getIncludeEntities().put(FrmEntityType.SEMANTIC_TYPE, includeTypes);
            }
            if (excludeTypes.size() > 0) {
                manifest.getExcludeEntities().put(FrmEntityType.SEMANTIC_TYPE, excludeTypes);
            }
        }
    }

    private void addMlcacheEntities(File nodeWorkingDir, FrmManifest manifest) throws IOException {
        Set include = ((Set)manifest.getIncludeEntities().getOrDefault((Object)FrmEntityType.MLCACHE, new HashSet())).stream().map(e -> e.getName()).collect(Collectors.toSet());
        Set exclude = ((Set)manifest.getExcludeEntities().getOrDefault((Object)FrmEntityType.MLCACHE, new HashSet())).stream().map(e -> e.getName()).collect(Collectors.toSet());
        HashSet includeExplained = new HashSet();
        if (include.size() != 0 || exclude.size() != 0) {
            File rootDir = FrmEntityType.MLCACHE.getDirectory(nodeWorkingDir);
            FileIOUtils.directoryListRecursive(rootDir, file -> {
                int includeIndex;
                String relativePath = rootDir.toPath().relativize(file.toPath()).toString();
                if ((relativePath.endsWith(".mlm") || relativePath.endsWith(".dic") || relativePath.endsWith(".swl")) && (includeIndex = this.fileIndex(include, relativePath)) > 0 && includeIndex >= this.fileIndex(exclude, relativePath)) {
                    includeExplained.add(relativePath);
                }
            }, dir -> true);
            manifest.getIncludeEntities().put(FrmEntityType.MLCACHE, includeExplained.stream().map(path -> new FrmEntity(new File((String)path).getName(), new File((String)path).getParent().toString())).collect(Collectors.toSet()));
            manifest.getExcludeEntities().put(FrmEntityType.MLCACHE, new HashSet());
        }
    }

    private int fileIndex(Set<String> set, String path) {
        int index = 0;
        for (String pattern : set) {
            if (pattern.equals("*")) {
                index = 1;
                continue;
            }
            if (!path.contains(pattern)) continue;
            index = Math.max(index, pattern.length());
        }
        return index;
    }

    static class Definition
    extends AbstractSLStatement {
        private String frmPath;
        private String nodeDir;
        private String ddxDir;
        private String manifestPath;
        private String mnodeScript;
        private String tnodeScript;

        Definition(String frmPath, String nodeDir, String ddxDir, String manifestPath) {
            super(MakeFrmOperation.NAME);
            this.frmPath = frmPath;
            this.nodeDir = nodeDir;
            this.ddxDir = ddxDir;
            this.manifestPath = manifestPath;
        }

        public String getFrmPath() {
            return this.frmPath;
        }

        public String getNodeDir() {
            return this.nodeDir;
        }

        public String getDdxDir() {
            return this.ddxDir;
        }

        public String getManifestPath() {
            return this.manifestPath;
        }

        public void setTnodeScript(String tnodeScript) {
            this.tnodeScript = tnodeScript;
        }

        public String getTnodeScript() {
            return this.tnodeScript;
        }

        public String getMnodeScript() {
            return this.mnodeScript;
        }

        public void setMnodeScript(String mnodeScript) {
            this.mnodeScript = mnodeScript;
        }
    }
}

