/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.runtime.mf.operation.LocalLocationModifier;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.tools.slang.AbstractSessionOperation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

class MakeDdxOperation
extends AbstractSessionOperation {
    private static final String NAME = "make ddx";
    private static final String RTCONTEXT_CDX = "rtcontext.cdx";
    private static final String HELP_MESSAGE = "Please specify CDX file(rtcontext.cdx) or folder that contains CDX file.";

    MakeDdxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("MAKE DDX").addModifier((AbstractModifier)new LocalLocationModifier().setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Generates a DDX (stdeploy.jar) out of the specified CDX file(rtcontext.cdx) or in the specified folder.");
        this.syntax.setExamples("make ddx at 'C:/StreamScape/deploy'\nmake ddx at 'C:/StreamScape/deploy/rtcontext.cdx'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(LocationModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Path cdxLocation = Paths.get(((Definition)statement).location, new String[0]);
        if (!Files.exists(cdxLocation, new LinkOption[0])) {
            throw new Exception("Location does not exist. Please specify CDX file(rtcontext.cdx) or folder that contains CDX file.");
        }
        if (Files.isRegularFile(cdxLocation, new LinkOption[0])) {
            if (RTCONTEXT_CDX.equals(cdxLocation.getFileName().toString())) {
                cdxLocation = cdxLocation.toAbsolutePath().getParent();
            } else {
                throw new Exception("Specified file is not 'rtcontext.cdx'. Please specify CDX file(rtcontext.cdx) or folder that contains CDX file.");
            }
        }
        StDeployGenerator.generate(cdxLocation.toFile());
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String location;

        Definition(String location) {
            super(MakeDdxOperation.NAME);
            this.location = location;
        }
    }
}

