/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.slang.AbstractConsumerOperation;
import com.streamscape.tools.slang.SLANGTool;

class ListConsumersOperation
extends AbstractConsumerOperation {
    private static final String NAME = "list consumers";

    public ListConsumersOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST CONSUMERS");
        this.syntax.addModifier((AbstractModifier)new Modifier("CONSOLE").setSyntaxHintSpace());
        this.syntax.setDescription("Returns a list of all console consumers.");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return ((SLANGTool)this.callable).isConnected() && !((SLANGTool)this.callable).isAnonymous();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet rowSet = new RowSet(ListConsumersOperation.createResultDescriptor());
        for (SLANGTool.ConsoleConsumer consumer : ((SLANGTool)this.callable).getConsumers()) {
            ListConsumersOperation.addValues(rowSet, new Object[]{consumer.name, consumer.async, this.getEventInfo(consumer), consumer.eventScope, consumer.actions, consumer.isStarted});
        }
        return new SLResponse(rowSet);
    }

    public static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListConsumersOperation.addColumn(result, "Name");
        ListConsumersOperation.addColumn(result, "Async");
        ListConsumersOperation.addColumn(result, "Event");
        ListConsumersOperation.addColumn(result, "Scope");
        ListConsumersOperation.addColumn(result, "Actions");
        ListConsumersOperation.addColumn(result, "Started");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(ListConsumersOperation.NAME);
        }
    }
}

