/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.mf.operation.frm.AbstractCreateFrmManifestOperation;
import com.streamscape.runtime.mf.operation.frm.FrmEntity;
import com.streamscape.runtime.mf.operation.frm.FrmEntityType;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.slang.SLANGTool;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class GenerateFrmManifestOperation
extends AbstractCreateFrmManifestOperation<SLANGTool> {
    public static final String NAME = "generate frm manifest";

    public GenerateFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("GENERATE FRM MANIFEST").addActionParameter(new IdentifierParameter("ManifestName"));
        CompoundModifier modifier = new CompoundModifier("AtModifier");
        modifier.setSyntaxHint(new SyntaxHint(" ", false));
        modifier.addModifier(new ChoiceModifier("").addPossibleValue("AT").addPossibleValue("@"));
        modifier.addParameter(new LocalPathParameter("FrmManifestPath"));
        this.syntax.addModifier(modifier);
        this.syntax.addParameter(((SetParameter)new SetParameter("OperationsSet").setRequired(false)).addParameter(new EnumParameter("OperationType").addPossibleValue("exclude").addPossibleValue("include").setCaseSensitive(false)).addParameter(this.createEntityTypeParameter()).addParameter(new ExpressionParameter("EntityName")).addParameter((AbstractParameter)new StringParameter("EntityNamespace").setRequired(false)));
        this.syntax.setDescription("Generates a new Fabric Resource Module manifest.\n\nAsterisk sign (*) can be used to refer to all entities of a particular type (e.g. all services or all JDBC factories).\nFor entities which support namespace (artifact, object) or subdirectories (working_dir) asterisk represents all objects\nwhich this namespace (or subdirectory) includes.\nFor HTTP_ACCEPTOR type, entity name should refer to the acceptor name and entity namespace can contain namespace\nalong with entity name. E.g. the rule (exclude http_acceptor Default 'webapps') specifies that all entities\nof Default HTTP acceptor in 'webapps' namespace will be excluded from the FRM.\n\nType ALL is used only in the global rules, such as (include all *) and (exclude all *).\nRule (include all *) means that the result FRM will contain all files from the working directory.\nRule (exclude all *) means that the result FRM will contain nothing.\n\nDefault manifest includes all files from .tfcache, .dscache and .htcache, but does not include other files from the working directory.\nTo generate FRM containing only few specific entities, the rule (exclude all *) can be used in a manifest.\nE.g. the rule (exclude all *, include service *) specified that the FRM will contain only service entities.\nDataspace FLOB files will be included into frm if node is running and FLOB directory located under working directory only.\n\nManifest will be generated at the specified directory.");
        String frmPath = "at 'c:/StreamScape' ";
        this.syntax.setExamples("generate frm manifest TestManifest " + frmPath + "(exclude service *)\ngenerate frm manifest TestManifest " + frmPath + "(exclude object * 'db')\ngenerate frm manifest TestManifest " + frmPath + "(exclude http-acceptor Default)\ngenerate frm manifest TestManifest " + frmPath + "(exclude http-acceptor Default 'webapps')\ngenerate frm manifest TestManifest " + frmPath + "(exclude all *, include service *)\ngenerate frm manifest TestManifest " + frmPath + "(exclude all *, include semantic-types-with-ancestor mytypes)\ngenerate frm manifest TestManifest " + frmPath + "(include working-dir *)\ngenerate frm manifest TestManifest " + frmPath + "(include working-dir * 'subdir')\ngenerate frm manifest TestManifest " + frmPath + "(include event-prototype my.event)\ngenerate frm manifest TestManifest " + frmPath + "(include mlcache *)\ngenerate frm manifest TestManifest " + frmPath + "(include mlcache TXCluster)\ngenerate frm manifest TestManifest " + frmPath + "(include mlcache *, exclude mlcache TXCluster)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = (Definition)super.convertDslToSl(statement);
        definition.setPath(statement.getParameter("FrmManifestPath").getValue());
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        File frmManifestFile = new File(definition.getPath(), definition.getManifestName() + ".frmm");
        if (frmManifestFile.exists()) {
            return new SLResponse("FRM manifest '" + definition.getManifestName() + "' already exists.", false);
        }
        FileIOUtils.putFile(definition.getPath(), definition.getManifestName() + ".frmm", GenerateFrmManifestOperation.getSerializer().serialize(this.getManifest(statement, session)).getBytes());
        return new SLResponse();
    }

    @Override
    protected AbstractCreateFrmManifestOperation.Definition createDefinition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
        return new Definition(manifestName, hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
    }

    public static class Definition
    extends AbstractCreateFrmManifestOperation.Definition {
        protected Definition(String manifestName, boolean hasGlobalInclude, Map<FrmEntityType, Set<FrmEntity>> includeEntities, boolean hasGlobalExclude, Map<FrmEntityType, Set<FrmEntity>> excludeEntities) {
            super(GenerateFrmManifestOperation.NAME, manifestName, hasGlobalInclude, includeEntities, hasGlobalExclude, excludeEntities);
        }
    }
}

