/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.cli.ClientContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.List;

class DiscoverOperation
extends AbstractSessionOperation {
    private static final String NAME = "discover";

    DiscoverOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DISCOVER");
        this.syntax.setDescription("Discovers links to which this tool can connect.");
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        List<DiscoveryLink> links = ClientContext.getInstance().discover();
        ((SLANGTool)this.callable).setDiscoveryLinks(links);
        RowSet result = new RowSet(DiscoverOperation.createResultDescriptor());
        for (DiscoveryLink link : links) {
            result.addToRowSet(new Object[]{link.getNodeName(), link.getLinkAddress()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DiscoverOperation.addColumn(result, "Node");
        DiscoverOperation.addColumn(result, "Link");
        return result;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(DiscoverOperation.NAME);
        }
    }
}

