/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.runtime.mf.operation.frm.AbstractDescribeFrmManifestOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.tools.slang.SLANGTool;
import java.io.File;
import java.io.FileNotFoundException;

public class DescribeFrmManifestOperation
extends AbstractDescribeFrmManifestOperation<SLANGTool> {
    public static final String NAME = "describe frm manifest";

    public DescribeFrmManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE FRM MANIFEST").addActionParameter(new LocalPathParameter("ManifestPath"));
        this.syntax.setDescription("Describes the specified Fabric Resource Module manifest.");
        this.syntax.setExamples("describe frm manifest 'c:/StreamScape/TestManifest.frmm'");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return !((SLANGTool)this.callable).isConnected();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return super.invoke(statement, session, timeout);
    }

    @Override
    protected byte[] getManifest(String name) throws Exception {
        try {
            return FileIOUtils.getFileContent(new File(name));
        }
        catch (UtilitiesException exception) {
            if (exception.getCause() instanceof FileNotFoundException) {
                throw new Exception("File '" + name + "' not found.");
            }
            throw exception;
        }
    }
}

