/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.mf.operation.LocalLocationModifier;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.tools.slang.AbstractDdxOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.io.File;
import java.util.Date;

public class DescribeDdxOperation
extends AbstractDdxOperation {
    public static final String NAME = "describe ddx";

    public DescribeDdxOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE DDX").addModifier((AbstractModifier)new LocalLocationModifier().setSyntaxHintSpace());
        DescribeDdxOperation.addKeyModifier(this.syntax);
        this.syntax.setDescription("Shows information about the deployment descriptor archive (i.e. stdeploy.jar) found at the specified location.");
        DescribeDdxOperation.addKeyDescription(this.syntax);
        this.syntax.setExamples("describe ddx at 'C:/StreamScape/deploy'\ndescribe ddx at 'C:/StreamScape/deploy' key '123'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return DescribeDdxOperation.doConvertDslToSl(this.getName(), statement);
    }

    public static SLStatement doConvertDslToSl(String operationName, DSLStatement statement) throws ParsingException {
        return new Definition(operationName, LocationModifier.getValue(statement), statement.existsParameter("SerialKey") ? statement.getParameter("SerialKey").getValue() : null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return DescribeDdxOperation.doInvoke((SLANGTool)this.callable, statement, session, timeout);
    }

    public static <T> SLResponse doInvoke(T callable, SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        CtxDeploymentDescriptor ddx = DeployUtils.getDeploymentDescriptor(new File(definition.location));
        SLResponse response = DescribeDdxOperation.confirmSecurityKey(callable, ddx, definition.key);
        if (response != null) {
            return response;
        }
        RowSet result = new RowSet(DescribeDdxOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Install Root", DescribeDdxOperation.skipNull(ddx.getSTRoot())});
        result.addToRowSet(new Object[]{"Startup Dir", DescribeDdxOperation.skipNull(ddx.getStartupDir())});
        result.addToRowSet(new Object[]{"Node", DescribeDdxOperation.skipNull(ddx.getContextName())});
        result.addToRowSet(new Object[]{"User", DescribeDdxOperation.skipNull(ddx.getSecurityPrincipal())});
        result.addToRowSet(new Object[]{"Domain", DescribeDdxOperation.skipNull(ddx.getReferral())});
        result.addToRowSet(new Object[]{"Cluster Enabled", ddx.isClusterEnabled()});
        result.addToRowSet(new Object[]{"Cluster Name", DescribeDdxOperation.skipNull(ddx.getClusterName())});
        result.addToRowSet(new Object[]{"Authentication Module", DescribeDdxOperation.skipNull(ddx.getAuthenticationModule())});
        result.addToRowSet(new Object[]{"Discovery Module", DescribeDdxOperation.skipNull(ddx.getDiscoveryProtocol())});
        result.addToRowSet(new Object[]{"Coherence", ddx.isCoherenceAutoBind()});
        result.addToRowSet(new Object[]{"Dataspace", ddx.isDataspaceAutoBind()});
        result.addToRowSet(new Object[]{"Presence", ddx.isPresence()});
        result.addToRowSet(new Object[]{"Repository", ddx.isRepositoryAutoBind()});
        result.addToRowSet(new Object[]{"Force Lock", ddx.isRuntimeCacheForceLock()});
        result.addToRowSet(new Object[]{"Security", ddx.isSecurityEnabled()});
        result.addToRowSet(new Object[]{"Unload on Last", ddx.isRuntimeContextAutoUnload()});
        result.addToRowSet(new Object[]{"Reference Class", DescribeDdxOperation.skipNull(ddx.getContainerClass())});
        result.addToRowSet(new Object[]{"Vendor", DescribeDdxOperation.skipNull(ddx.getVendorString())});
        result.addToRowSet(new Object[]{"DDX Security", !StringUtils.isEmpty(ddx.getLicenseKey())});
        result.addToRowSet(new Object[]{"Expiration Time", ddx.getLicenseTs() != 0L ? new Date(ddx.getLicenseTs()) : "N/A"});
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeDdxOperation.addColumn(result, "Property");
        DescribeDdxOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractDdxOperation.AbstractDefinition {
        String key;

        Definition(String operationName, String location, String key) {
            super(operationName, location);
            this.key = key;
        }
    }
}

