/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractClientOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.Arrays;
import java.util.List;

class DescribeClientOperation
extends AbstractSessionOperation {
    private static final String NAME = "describe client";

    DescribeClientOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE CLIENT");
        this.syntax.addActionParameter((SyntaxParameter)((ExpressionParameter)((ExpressionParameter)new ExpressionParameter("ClientId").setRequired(false)).setExcludedDelimiters("@=")).setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<SLANGTool>(this){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return Arrays.asList("");
            }
        }));
        this.syntax.setDescription("Shows information about the current session client.");
    }

    @Override
    public String getSyntax(MFSession session) {
        return NAME;
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return AbstractClientOperation.createDefinition(NAME, statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractClientOperation.Definition definition = (AbstractClientOperation.Definition)statement;
        if (((SLANGTool)this.callable).isConnected()) {
            if (!((SLANGTool)this.callable).isAnonymous()) {
                SLResponse response;
                String clientId = ((SLANGTool)this.callable).getConnection().getComponentReference().getName();
                if (definition.getClientId() == null) {
                    definition.setClientId(clientId);
                }
                if ((response = ((SLANGTool)this.callable).invokeSessionRequest(statement)).getRowSet() != null && definition.getClientId().equals(clientId)) {
                    ((SLANGTool)this.callable).fillSessionInfo(response.getRowSet());
                }
                return response;
            }
            return this.createLocalResponse();
        }
        if (definition.getClientId() != null) {
            throw new ParsingException(this.getSyntaxErrorMessage("Parsing error, unknown symbols at the end of the query: '" + definition.getClientId() + "'."));
        }
        return this.createLocalResponse();
    }

    private SLResponse createLocalResponse() throws Exception {
        RowSet result = new RowSet(DescribeClientOperation.createSimpleResultDescriptor());
        ((SLANGTool)this.callable).fillSessionInfo(result);
        return new SLResponse(result);
    }
}

