/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.cli.ClientContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.discovery.DiscoveryLink;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.ArrayList;
import java.util.List;

public class ConnectOperation
extends AbstractSessionOperation {
    private static final String NAME = "connect";

    public ConnectOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("CONNECT").addActionParameter((SyntaxParameter)new ExpressionParameter("URL or NodeName").setName("URL"));
        CompoundModifier userPassword = ((CompoundModifier)new CompoundModifier("UserPassword").setSyntaxHintSpace()).addModifier((AbstractModifier)new Modifier().addParameter(new StringParameter("Username"))).addModifier((AbstractModifier)new Modifier().addParameter((SyntaxParameter)new StringParameter("Password").setRequired(false)));
        ChoiceModifier credentials = (ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("Credentials", false).setSyntaxHintSpace()).addModifier(userPassword)).addModifier((AbstractModifier)new Modifier("KEY").addParameter(new StringParameter("SecurityToken")));
        this.syntax.addModifier(credentials);
        this.syntax.addModifier((AbstractModifier)new Modifier("TIMEOUT", false).addParameter(new IntegerParameter("Timeout").setRange(1, Integer.MAX_VALUE)));
        this.syntax.addModifier((AbstractModifier)new Modifier("RELIABLE", false).setAlias("R"));
        this.syntax.addModifier((AbstractModifier)new Modifier("SSL", false).setAlias("S"));
        this.syntax.addModifier(((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("DIAGNOSTIC").setAlias("DIAG"))).addPossibleValue("ACTIVATOR"));
        this.syntax.setDescription("connect <URL>      - Connects to the sysplex using the specified URL.\n                     URL must have the following format: [tlp(s)://]<HostName>:<PortNumber> (e.g. localhost:5000 or tlp://localhost:5000).\nconnect <NodeName> - Connects to the specified node.\n                     At first, the 'discover' operation will be performed to find out URL of this node.\n\nOptional parameters:\n\n   <Username>          - User name that is used for authentication.\n   <Password>          - User password that is used for authentication.\n   key <SecurityToken> - Security token (Web Application Token) that is used for authentication.\n                         Mutually exclusive with <Username>/<Password> parameters.\n                         Cannot be used for Diagnostic or Activator sessions.   timeout <Timeout>   - Time (in seconds) of waiting for connection establishment.\n                         Default is 10 seconds.\n   reliable            - Allows to restore session after connection break.\n                         This parameter is not applicable to Diagnostic or Activator sessions.\n   ssl                 - Allows to establish SSL connection.\n   diagnostic          - Opens a diagnostic session to the sysplex using the specified URL or node name.\n   activator           - Opens a session to the Activator using the specified URL.");
        this.syntax.setExamples("connect localhost:5000\nconnect localhost:5000 'anonymous'\nconnect localhost:5000 'user1' '123'\nconnect localhost:5000 key 'example'\nconnect TestNode\nconnect localhost:5000 diagnostic\nconnect localhost:5000 'user1' '123' diag\nconnect localhost:5000 'user1' '123' activator\nconnect localhost:5000 timeout 5\nconnect localhost:5000 'user1' '123' reliable");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition definition = new Definition(statement.getParameter("URL").getValue());
        if (statement.existsParameter("Username")) {
            definition.setUsername(statement.getParameter("Username").getValue());
        }
        if (statement.existsParameter("Password")) {
            definition.setPassword(statement.getParameter("Password").getValue());
        }
        if (statement.existsParameter("SecurityToken")) {
            definition.setUsername(null);
            definition.setPassword(statement.getParameter("SecurityToken").getValue());
        }
        if (statement.existsParameter("Timeout")) {
            definition.setTimeout(Integer.parseInt(statement.getParameter("Timeout").getValue()));
        }
        if (statement.existsModifier("RELIABLE")) {
            definition.setReliable(true);
        }
        if (statement.existsModifier("SSL")) {
            definition.setSSL(true);
        }
        if (statement.existsModifier("DIAGNOSTIC")) {
            definition.setSessionType(AbstractSLANGTool.SessionType.DIAGNOSTIC);
        }
        if (statement.existsModifier("ACTIVATOR")) {
            definition.setSessionType(AbstractSLANGTool.SessionType.ACTIVATOR);
        }
        return definition;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.url.contains(":")) {
            ((SLANGTool)this.callable).connect(definition.url, definition.username, definition.password, definition.timeout, definition.reliable, definition.ssl, definition.sessionType);
            if (((SLANGTool)this.callable).getConnection() != null) {
                ((SLANGTool)this.callable).setConsoleCCSID(((SLANGTool)this.callable).getConnection().getCCSID());
            }
        } else {
            ArrayList<DiscoveryLink> badLinks;
            List<DiscoveryLink> oldLinks = ((SLANGTool)this.callable).getDiscoveryLinks(definition.url);
            if (this.connect(oldLinks, badLinks = new ArrayList<DiscoveryLink>(), definition, true) == AbstractSLANGTool.ConnectResult.NOK) {
                ((SLANGTool)this.callable).println("\nDiscover...");
                ((SLANGTool)this.callable).setDiscoveryLinks(ClientContext.getInstance().discover());
                List<DiscoveryLink> newLinks = ((SLANGTool)this.callable).getDiscoveryLinks(definition.url);
                if (this.connect(newLinks, badLinks, definition, false) == AbstractSLANGTool.ConnectResult.NOK) {
                    return new SLResponse("Suitable URL not found.", false);
                }
            }
        }
        return new AbstractSLANGTool.IgnoredResponse();
    }

    private AbstractSLANGTool.ConnectResult connect(List<DiscoveryLink> discoveryLinks, List<DiscoveryLink> badLinks, Definition definition, boolean firstCall) {
        AbstractSLANGTool.ConnectResult result = AbstractSLANGTool.ConnectResult.NOK;
        for (DiscoveryLink link : discoveryLinks) {
            if (!firstCall && badLinks.contains(link)) continue;
            result = ((SLANGTool)this.callable).connect(link.getLinkAddress().toString(), definition.username, definition.password, definition.timeout, definition.reliable, definition.ssl, definition.sessionType);
            if (result == AbstractSLANGTool.ConnectResult.OK) break;
            if (!firstCall) continue;
            badLinks.add(link);
        }
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String url;
        private String username;
        private String password;
        private int timeout = -1;
        private boolean reliable = false;
        private Boolean ssl = null;
        private AbstractSLANGTool.SessionType sessionType = AbstractSLANGTool.SessionType.STANDARD;

        Definition(String url) {
            super(ConnectOperation.NAME);
            this.url = url;
        }

        void setUsername(String username) {
            this.username = username;
        }

        void setPassword(String password) {
            this.password = password;
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        void setReliable(boolean reliable) {
            this.reliable = reliable;
        }

        void setSSL(boolean ssl) {
            this.ssl = ssl;
        }

        void setSessionType(AbstractSLANGTool.SessionType sessionType) {
            this.sessionType = sessionType;
        }
    }
}

