/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.runtime.mf.operation.security.AlterPasswordOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class AlterPasswordOperation
extends AbstractSessionOperation {
    private static final String NAME = "alter password";

    AlterPasswordOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER PASSWORD");
        this.syntax.addModifier(((CompoundModifier)((CompoundModifier)new CompoundModifier().setRequired(false)).setSyntaxHintSpace()).addParameter(new IdentifierParameter("UserName")).addModifier((AbstractModifier)new Modifier("OLD").addParameter(new StringParameter("OldPassword", Character.valueOf('\''), Character.valueOf('\'')))).addModifier((AbstractModifier)new Modifier("NEW").addParameter(new StringParameter("NewPassword", Character.valueOf('\''), Character.valueOf('\'')))));
        this.syntax.setDescription(" alter password                                                    - Changes a password of the session's user.\n alter password <UserName> old '<OldPassword>' new '<NewPassword>' - Changes a password of the specified user.");
        this.syntax.setExamples("alter password\nalter password User1 old 'xxx' new 'yyy'");
        this.syntax.addTag(OperationTag.security);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        if (statement.getParameter("UserName").isPresent()) {
            return new Definition(statement.getParameter("UserName").getValue(), statement.getParameter("OldPassword").getValue(), statement.getParameter("NewPassword").getValue());
        }
        return new Definition();
    }

    @Override
    public boolean isVisible(MFSession session) {
        return ((SLANGTool)this.callable).isConnected() && !((SLANGTool)this.callable).isAnonymous() && !((SLANGTool)this.callable).isSpecial();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.getUserName() == null) {
            try {
                String userName = ((SLANGTool)this.callable).getConnection().getUserName();
                ((SLANGTool)this.callable).println("");
                String oldPassword = ((SLANGTool)this.callable).readPassword("Old password: ");
                if (oldPassword == null) {
                    return new AbstractSLANGTool.InterruptedResponse();
                }
                String newPassword = ((SLANGTool)this.callable).readPassword("New password: ");
                if (newPassword == null) {
                    return new AbstractSLANGTool.InterruptedResponse();
                }
                String newPasswordConfirmation = ((SLANGTool)this.callable).readPassword("Confirm new password: ");
                if (newPasswordConfirmation == null) {
                    return new AbstractSLANGTool.InterruptedResponse();
                }
                if (!newPassword.equals(newPasswordConfirmation)) {
                    return new SLResponse("Password confirmation failed.", false);
                }
                statement = new AlterPasswordOperation.Definition(userName, oldPassword, newPassword);
            }
            catch (ReadInterruptedException exception) {
                return new AbstractSLANGTool.InterruptedResponse();
            }
        }
        return ((SLANGTool)this.callable).invokeSessionRequest(statement);
    }

    static class Definition
    extends AlterPasswordOperation.Definition {
        Definition() {
        }

        Definition(String userName, String oldPassword, String newPassword) {
            super(userName, oldPassword, newPassword);
        }
    }
}

