/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeployUtils;
import com.streamscape.runtime.deploy.StDeployGenerator;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.tools.slang.AbstractDdxOperation;
import java.io.File;

public class AlterDdxOperation
extends AbstractDdxOperation {
    private static final String NAME = "alter ddx";

    AlterDdxOperation() {
        this.createDSLSyntax(NAME);
        AlterDdxOperation.addKeyModifier(this.syntax);
        this.syntax.setDescription("Alters the specified properties of the deployment descriptor archive (stdeploy.jar) found at the specified location.");
        AlterDdxOperation.addKeyDescription(this.syntax);
        this.syntax.setExamples("alter ddx at 'C:/StreamScape' set properties (user = 'Bob', password = '123')\nalter ddx at 'C:/StreamScape' set properties (clusterEnabled = 'true', cluster = 'Primary') key '123'");
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        AlterDdxOperation.createDSLSyntaxForSetOperations(name, this.syntax, new AbstractDdxOperation.AbstractSyntaxUpdater(this){

            @Override
            public String getPropertiesDescription() {
                return "   node                 - Node name.\n" + super.getPropertiesDescription();
            }
        }, true, true);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return AlterDdxOperation.doConvertDslToSl(this.getName(), statement);
    }

    public static SLStatement doConvertDslToSl(String operationName, DSLStatement statement) throws ParsingException {
        Definition result = new Definition(operationName);
        AlterDdxOperation.fillSetPropertiesDefinition(result, statement);
        result.key = statement.existsParameter("SerialKey") ? statement.getParameter("SerialKey").getValue() : null;
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return AlterDdxOperation.doInvoke(statement, session, timeout);
    }

    public static SLResponse doInvoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        CtxDeploymentDescriptor descriptor = DeployUtils.getDeploymentDescriptor(new File(definition.location));
        SLResponse response = AlterDdxOperation.confirmSecurityKey(null, descriptor, definition.key);
        if (response != null) {
            return response;
        }
        AlterDdxOperation.setProperties(descriptor, definition.properties);
        StDeployGenerator.generate(new File(definition.location), descriptor);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractDdxOperation.SetPropertiesDefinition {
        String key;

        Definition(String operationName) {
            super(operationName);
        }
    }
}

