/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.runtime.mf.operation.EventScopeModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.modifier.RepeatableModifier;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.EventIdParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.slang.AbstractConsumerOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AddConsumerOperation
extends AbstractConsumerOperation {
    private static final String NAME = "add consumer";

    public AddConsumerOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD").setPredicate(new Predicate("ASYNC", false)).setSubject((Subject)new Subject("CONSUMER").addParameter(new IdentifierParameter("Name")));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR").addParameter(new EventIdParameter("EventId"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("WHEN", false).addParameter((SyntaxParameter)new ExpressionParameter("EventSelector", '(', ')').setEndDelimiterToCommandEnd())).setSyntaxHintSpace());
        this.syntax.addModifier(new EventScopeModifier(false, false, EventScope.GLOBAL));
        Modifier printText = (Modifier)new Modifier("PRINT TEXT").addParameter(new StringParameter("PrintText"));
        Modifier printEvent = (Modifier)new Modifier("PRINT EVENT").addParameter((SyntaxParameter)new ExpressionParameter("SDRPath").setRequired(false));
        BlockModifier print = new BlockModifier("", "PrintBlock").addModifier((AbstractModifier)new RepeatableModifier().addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier("PrintSet").addModifier(printText)).addModifier(printEvent)));
        this.syntax.addModifier(new CompoundModifier("OnEvent").addModifier(new Modifier("ON EVENT")).addModifier(print));
        this.syntax.addModifier(new Modifier("START", false));
        this.syntax.setDescription("Adds a new consumer to the SLANG tool console.\nThis consumer listens for the specified event and executes the specified actions when the event is received.\nBy default, the consumer after starting blocks the console input until Ctrl+K is pressed.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   for <EventId> - Identifier of the event that the consumer listens for.\n   on event      - List of actions that the consumer executes after the event receiving.\n                   The following actions are supported:\n                      print text <Text>     - Prints the specified text.\n                      print event <SDRPath> - Prints the whole event or the event field specified by the SDR path.\n\nOptional parameters:\n\n   async                 - Indicates that the consumer after starting will not block the console input.\n   when (<EventSelector> - Event selector of the event that the consumer listens for.\n   event scope           - Event scope of the consumer. Default is GLOBAL.\n   start                 - Starts the consumer immediately after adding.");
        this.syntax.setExamples("add consumer Test for [event.text] on event (print text 'Test')\nadd async consumer Test for [event.text] on event (print event)\nadd consumer Test for [event.text] on event (print event //data)");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Name").getValue(), statement.existsPredicate(), statement.getParameter("EventId").getValue(), statement.existsParameter("EventSelector") ? statement.getParameter("EventSelector").getValue() : null, EventScopeModifier.getValue(this.syntax, statement), this.getActions(statement), statement.existsModifier("START"));
    }

    private List<SLANGTool.ConsumerAction> getActions(DSLStatement statement) {
        ArrayList<SLANGTool.ConsumerAction> result = new ArrayList<SLANGTool.ConsumerAction>();
        StatementBlockValue block = statement.getBlock("PrintBlock");
        for (int i = 0; i < block.getLinesCount(); ++i) {
            StatementValueList item = block.getLineByIndex(i);
            if (item.existsParameter("PrintText")) {
                SLANGTool sLANGTool = (SLANGTool)this.callable;
                Objects.requireNonNull(sLANGTool);
                result.add(sLANGTool.new SLANGTool.PrintTextAction(item.toString().trim(), item.getParameter("PrintText").getValue()));
                continue;
            }
            if (!item.existsModifier("PRINT EVENT")) continue;
            SLANGTool sLANGTool = (SLANGTool)this.callable;
            Objects.requireNonNull(sLANGTool);
            result.add(sLANGTool.new SLANGTool.PrintEventAction(item.toString().trim(), item.existsParameter("SDRPath") ? item.getParameter("SDRPath").getValue() : null));
        }
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((SLANGTool)this.callable).addConsumer(definition.consumerName, definition.async, definition.eventId, definition.selector, definition.scope, definition.actions, definition.start);
        return definition.async ? (definition.start ? new SLResponse(SLANGTool.getAsyncConsumerMessage()) : new SLResponse()) : new PseudoSLResponse();
    }

    static class Definition
    extends AbstractConsumerOperation.Definition {
        private boolean async;
        private String eventId;
        private String selector;
        private EventScope scope;
        private List<SLANGTool.ConsumerAction> actions;
        private boolean start;

        Definition(String consumerName, boolean async, String eventId, String selector, EventScope scope, List<SLANGTool.ConsumerAction> actions, boolean start) {
            super(AddConsumerOperation.NAME, consumerName);
            this.async = async;
            this.eventId = eventId;
            this.selector = selector;
            this.scope = scope;
            this.actions = actions;
            this.start = start;
        }
    }
}

