/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;

class AddAccessPointOperation
extends AbstractSessionOperation {
    private static final String NAME = "add access point";

    AddAccessPointOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD ACCESS POINT");
        this.syntax.addActionParameter(new ExpressionParameter("URL"));
        this.syntax.setDescription("Adds the access point that is used during reconnect of the session.");
        this.syntax.setExamples("add access point localhost:5001");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("URL").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ((SLANGTool)this.callable).addURL(((Definition)statement).url);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String url;

        Definition(String url) {
            super(AddAccessPointOperation.NAME);
            this.url = url;
        }
    }
}

