/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.Context;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.deploy.DeploymentDescriptor;
import com.streamscape.runtime.mf.operation.LocalLocationModifier;
import com.streamscape.runtime.mf.operation.LocationModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.SLANGTool;
import java.util.Map;

public abstract class AbstractDdxOperation
extends AbstractSessionOperation {
    static final String NODE = "node";
    static final String USER = "user";
    static final String PASSWORD = "password";
    static final String VENDOR = "vendor";
    static final String DOMAIN = "domain";
    static final String CLUSTER_ENABLED = "clusterEnabled";
    static final String CLUSTER = "cluster";
    static final String STROOT = "stroot";
    static final String STARTUP_DIR = "startupDir";
    static final String CONTEXT_TYPE = "contextType";
    static final String CONTAINER_CLASS = "containerClass";
    static final String AUTHENTICATION_MODULE = "authenticationModule";
    static final String DISCOVERY_MODULE = "discoveryModule";
    static final String PRESENCE_ENABLED = "presenceEnabled";
    static final String COHERENCE_ENABLED = "coherenceEnabled";
    static final String UNLOAD_ON_LAST = "unloadOnLast";
    static final String REPOSITORY_IO_TIMEOUT = "repositoryIoTimeout";
    static final String REPOSITORY_TX_TIMEOUT = "repositoryTxTimeout";
    static final String SERIAL_KEY = "serialKey";

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.ddx);
    }

    public static void createDSLSyntaxForSetOperations(String operationName, DSLStatementSyntax syntax, SyntaxUpdater updater, boolean locationRequired, boolean setPropertiesRequired) {
        syntax.setAction(operationName);
        updater.addNodeModifier();
        syntax.addModifier((AbstractModifier)new LocalLocationModifier(locationRequired).setSyntaxHintSpace());
        SetParametersModifier setModifier = new SetParametersModifier("SET PROPERTIES", "Properties", setPropertiesRequired);
        if (setPropertiesRequired) {
            setModifier.setSyntaxHintSpace();
        }
        syntax.addModifier(setModifier);
        syntax.setSyntaxDescription("The following properties are supported:\n\n" + updater.getPropertiesDescription());
    }

    public static void addKeyModifier(DSLStatementSyntax syntax) {
        syntax.addModifier((AbstractModifier)new Modifier("KEY", false).addParameter(new StringParameter("SerialKey")));
    }

    public static void addKeyDescription(DSLStatementSyntax syntax) {
        String description = syntax.getSyntaxDescription();
        syntax.setSyntaxDescription((String)(description != null ? description + "\n\n" : "") + "Optional parameters:\n\n   key - Serial key (if it is specified in the deployment descriptor).");
    }

    public static void setProperties(CtxDeploymentDescriptor descriptor, Map<String, String> properties) throws Exception {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            AbstractDdxOperation.setProperty(descriptor, entry.getKey(), entry.getValue());
        }
    }

    private static void setProperty(CtxDeploymentDescriptor descriptor, String name, String value) throws Exception {
        if (name.equalsIgnoreCase(NODE)) {
            descriptor.setContextName(value);
        } else if (name.equalsIgnoreCase(USER)) {
            descriptor.setSecurityPrincipal(value);
        } else if (name.equalsIgnoreCase(PASSWORD)) {
            descriptor.setSecurityCredentials(value);
        } else if (name.equalsIgnoreCase(VENDOR)) {
            descriptor.setVendorString(value);
        } else if (name.equalsIgnoreCase(DOMAIN)) {
            descriptor.setReferral(value);
        } else if (name.equalsIgnoreCase(CLUSTER_ENABLED)) {
            descriptor.setClusterEnabled(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase(CLUSTER)) {
            descriptor.setClusterName(value);
        } else if (name.equalsIgnoreCase(STROOT)) {
            descriptor.setSTRoot(value);
        } else if (name.equalsIgnoreCase(STARTUP_DIR)) {
            descriptor.setStartupDir(value);
        } else if (name.equalsIgnoreCase(CONTEXT_TYPE)) {
            descriptor.setContextType(Context.valueOf(value));
        } else if (name.equalsIgnoreCase(CONTAINER_CLASS)) {
            descriptor.setContainerClass(value);
        } else if (name.equalsIgnoreCase(AUTHENTICATION_MODULE)) {
            descriptor.setAuthenticationModule(value);
        } else if (name.equalsIgnoreCase(DISCOVERY_MODULE)) {
            descriptor.setDiscoveryProtocol(value);
        } else if (name.equalsIgnoreCase(PRESENCE_ENABLED)) {
            descriptor.setPresence(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase(COHERENCE_ENABLED)) {
            descriptor.setCoherenceAutoBind(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase(UNLOAD_ON_LAST)) {
            descriptor.setRuntimeContextAutoUnload(SetParametersModifier.getBoolean(name, value));
        } else if (name.equalsIgnoreCase(REPOSITORY_IO_TIMEOUT)) {
            descriptor.setIOTimeout(value);
        } else if (name.equalsIgnoreCase(REPOSITORY_TX_TIMEOUT)) {
            descriptor.setContextTimeout(value);
        } else if (name.equalsIgnoreCase(SERIAL_KEY)) {
            descriptor.setLicenseKey(value);
        } else {
            throw new FabricException("Unknown property '" + name + "'.");
        }
    }

    public static <T> SLResponse confirmSecurityKey(T callable, DeploymentDescriptor descriptor, String key) throws Exception {
        if (!StringUtils.isEmpty(descriptor.getLicenseKey())) {
            if (StringUtils.isEmpty(key)) {
                if (callable instanceof SLANGTool) {
                    ((SLANGTool)callable).println("");
                    key = ((SLANGTool)callable).readPassword("Serial key: ");
                    if (key == null) {
                        return new AbstractSLANGTool.InterruptedResponse();
                    }
                } else {
                    throw new FabricException("Serial key not specified.");
                }
            }
            if (!descriptor.getLicenseKey().equals(key)) {
                throw new FabricException("Serial key confirmation failed.");
            }
        }
        return null;
    }

    public static SetPropertiesDefinition createSetPropertiesDefinition(String operationName, DSLStatement statement) throws ParsingException {
        SetPropertiesDefinition result = new SetPropertiesDefinition(operationName);
        AbstractDdxOperation.fillSetPropertiesDefinition(result, statement);
        return result;
    }

    public static void fillSetPropertiesDefinition(SetPropertiesDefinition definition, DSLStatement statement) throws ParsingException {
        definition.location = LocationModifier.getValue(statement);
        definition.properties = SetParametersModifier.getValue(statement, "Properties");
    }

    public static interface SyntaxUpdater {
        public void addNodeModifier();

        public String getPropertiesDescription();
    }

    public static class SetPropertiesDefinition
    extends AbstractDefinition {
        Map<String, String> properties;

        SetPropertiesDefinition(String operationName) {
            super(operationName);
        }

        SetPropertiesDefinition(String operationName, String location, Map<String, String> properties) {
            super(operationName, location);
            this.properties = properties;
        }
    }

    public static class AbstractDefinition
    extends AbstractSLStatement {
        String location;

        AbstractDefinition(String operationName) {
            super(operationName);
        }

        public AbstractDefinition(String operationName, String location) {
            super(operationName);
            this.location = location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }

    public static class AbstractSyntaxUpdater
    implements SyntaxUpdater {
        @Override
        public void addNodeModifier() {
        }

        @Override
        public String getPropertiesDescription() {
            return "   user                 - Name of Runtime user. Default is 'Admin'.\n   password             - Password of Runtime user. Default is 'Admin'.\n   vendor               - Vendor string.\n   domain               - Name of Domain. Default is 'Domain1'.\n   clusterEnabled       - Specifies if Cluster feature is enabled. Default is false.\n   cluster              - Name of Cluster.\n   stroot               - Path to install root. Default is 'C:/StreamScape'.\n   startupDir           - Path to startup directory.\n   contextType          - Type of environment context.\n   containerClass       - Class of Container.\n   authenticationModule - Name of Authentication Module.\n   discoveryModule      - Name of Discovery Module.\n   presenceEnabled      - Specifies if Presence feature is enabled. Default is true.\n   coherenceEnabled     - Specifies if Coherence feature is enabled. Default is true.\n   unloadOnLast         - Specifies if a node will be shut down after unbind of a last component.\n   repositoryIoTimeout  - Timeout (in milliseconds) for CacheIOThread in the Repository.\n   repositoryTxTimeout  - Timeout (in milliseconds) for transactions in the Repository.\n   serialKey            - Serial key of this deployment descriptor.";
        }
    }
}

