/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.parser;

import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.parser.ParserException;

public class ParserExceptionBuilder {
    public static ParserException unexpectedToken(Lexer<?> lexer) {
        return ParserExceptionBuilder.unexpectedToken(lexer, null);
    }

    public static ParserException unexpectedToken(Lexer<?> lexer, Object ... expectedTokens) {
        StringBuilder builder = new StringBuilder();
        if (lexer.getCurrentToken().getCommonType() == CommonTokenType.UNREAD_TOKEN) {
            try {
                lexer.readToken();
            }
            catch (LexerException exception) {
                exception.printStackTrace();
            }
        }
        String tokenName = lexer.getCurrentToken().getCommonType() != CommonTokenType.UNREAD_TOKEN ? lexer.getCurrentToken().getTokenName().toLowerCase() + "(" + lexer.getCurrentToken().getValue() + ")." : "token.";
        builder.append("Unexpected " + tokenName);
        if (expectedTokens != null) {
            builder.append(" Expected ");
            for (Object expectedToken : expectedTokens) {
                builder.append(String.valueOf(expectedToken) + " or ");
            }
            builder.setLength(builder.length() - 4);
            builder.append(".");
        }
        return ParserExceptionBuilder.initException(lexer, new ParserException(ParserExceptionBuilder.getProcessedPart(lexer), builder.toString()));
    }

    public static ParserException unexpectedToken(Lexer<?> lexer, TokenType ... expectedTokenTypes) {
        String[] expectedTokens = null;
        if (expectedTokenTypes != null) {
            expectedTokens = new String[expectedTokenTypes.length];
            for (int i = 0; i < expectedTokenTypes.length; ++i) {
                expectedTokens[i] = expectedTokenTypes[i].toString().toLowerCase() + "(" + expectedTokenTypes[i].getValue() + ")";
            }
        }
        return ParserExceptionBuilder.unexpectedToken(lexer, expectedTokens);
    }

    public static String getProcessedPart(Lexer<?> lexer) {
        Object processedPart = "";
        if (lexer.getCurrentTokenPosition() > 50) {
            processedPart = "...";
        }
        processedPart = (String)processedPart + lexer.getPartBeforeCurrentToken(50);
        return processedPart;
    }

    public static ParserException parserException(Lexer<?> lexer, String message) {
        return ParserExceptionBuilder.initException(lexer, new ParserException(ParserExceptionBuilder.getProcessedPart(lexer), message));
    }

    public static ParserException parserException(Lexer<?> lexer, int position, String message) {
        return ParserExceptionBuilder.initException(lexer, position, new ParserException(null, message));
    }

    private static ParserException initException(Lexer<?> lexer, ParserException exception) {
        return ParserExceptionBuilder.initException(lexer, lexer.getCurrentTokenPosition(), exception);
    }

    private static ParserException initException(Lexer<?> lexer, int position, ParserException exception) {
        exception.setLine(lexer.getLine(position));
        exception.setLineNumber(lexer.getLineNumber(position));
        exception.setPositionInLine(lexer.getPositionInLine(position) + 1);
        return exception;
    }
}

