/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.parser;

import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.parser.ParserCompletionException;
import com.streamscape.tools.parser.ParserException;
import com.streamscape.tools.parser.ParserExceptionBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParser<T extends TokenType> {
    protected Lexer<T> lexer;
    protected boolean isCompleteMode = false;
    private List<DSLCompletion> completions;
    private List<Suggestion> suggestions;

    protected AbstractParser(Class<T> tokenTypeClass) throws ParserException {
        try {
            this.lexer = LexerFactory.createLexer(tokenTypeClass);
        }
        catch (LexerException exception) {
            throw new ParserException(null, "Failed to create lexer. Cause: " + exception.getMessage());
        }
    }

    public Lexer<T> getLexer() {
        return this.lexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLCompletion complete(String buffer) {
        this.isCompleteMode = true;
        try {
            this.onComplete(buffer);
        }
        catch (ParserCompletionException exception) {
            this.addCompletion(exception.getCompletion());
            DSLCompletion dSLCompletion = this.mergeCompletions();
            return dSLCompletion;
        }
        catch (ParserException exception) {
            DSLCompletion result = this.mergeCompletions();
            if (result == null && this.isCompleteMode) {
                result = new DSLCompletion(exception);
            }
            DSLCompletion dSLCompletion = result;
            return dSLCompletion;
        }
        finally {
            this.isCompleteMode = false;
        }
        return null;
    }

    protected abstract void onComplete(String var1) throws ParserException;

    protected boolean isSuggestionsNotEmpty() {
        return this.suggestions != null && this.suggestions.size() > 0 || this.completions != null && this.completions.size() > 0;
    }

    protected void addSuggestion(Suggestion suggestion) {
        if (suggestion == null) {
            return;
        }
        if (this.suggestions == null) {
            this.suggestions = new ArrayList<Suggestion>();
        }
        this.suggestions.add(suggestion);
    }

    private void moveSuggestionsToCompletions() {
        if (this.suggestions != null && this.suggestions.size() > 0) {
            DSLCompletion completion = new DSLCompletion();
            completion.addSuggestions(this.suggestions);
            this.suggestions.clear();
            this.addCompletion(completion);
        }
    }

    protected void addCompletion(DSLCompletion completion) {
        if (completion == null) {
            return;
        }
        this.moveSuggestionsToCompletions();
        if (this.completions == null) {
            this.completions = new ArrayList<DSLCompletion>();
        }
        this.completions.add(completion);
    }

    protected DSLCompletion mergeCompletions() {
        if (this.isCompleteMode) {
            this.moveSuggestionsToCompletions();
            DSLCompletion completion = null;
            if (this.completions != null && this.completions.size() > 0) {
                completion = this.completions.get(0);
                for (int i = 1; i < this.completions.size(); ++i) {
                    completion = CompoundCompleter.mergeCompletions("", completion, this.completions.get(i));
                }
            }
            return completion;
        }
        return null;
    }

    protected int readInt() throws ParserException {
        try {
            this.lexer.readToken(CommonTokenType.LITERAL);
            return Integer.valueOf(this.lexer.getCurrentToken().getValue());
        }
        catch (LexerException exception) {
            throw this.unexpectedToken("integer value");
        }
    }

    protected ParserException unexpectedToken() {
        return ParserExceptionBuilder.unexpectedToken(this.lexer);
    }

    protected ParserException unexpectedToken(TokenType ... expectedTokenTypes) {
        return ParserExceptionBuilder.unexpectedToken(this.lexer, expectedTokenTypes);
    }

    protected ParserException unexpectedToken(Object ... expectedTokens) {
        return ParserExceptionBuilder.unexpectedToken(this.lexer, expectedTokens);
    }

    protected ParserException parserException(String message) {
        return ParserExceptionBuilder.parserException(this.lexer, message);
    }

    protected ParserException parserException(int position, String message) {
        return ParserExceptionBuilder.parserException(this.lexer, position, message);
    }

    protected class PrefixParserCompleter {
        private PrefixCompleter[] completers;
        private boolean withRead = false;
        private boolean spaceFirst = true;
        private boolean throwException = true;

        public PrefixParserCompleter completers(PrefixCompleter ... completers) {
            this.completers = completers;
            return this;
        }

        public PrefixParserCompleter withRead(boolean withRead) {
            this.withRead = withRead;
            return this;
        }

        public PrefixParserCompleter spaceFirst(boolean spaceFirst) {
            this.spaceFirst = spaceFirst;
            return this;
        }

        public PrefixParserCompleter throwException(boolean throwException) {
            this.throwException = throwException;
            return this;
        }

        public void complete() throws LexerException, ParserCompletionException {
            if (AbstractParser.this.isCompleteMode) {
                String prefix = null;
                if (this.withRead) {
                    AbstractParser.this.lexer.readToken();
                }
                prefix = AbstractParser.this.lexer.getCurrentToken().getValue();
                this.complete(prefix);
            }
        }

        public void complete(String prefix) throws LexerException, ParserCompletionException {
            if (AbstractParser.this.isCompleteMode) {
                if (!AbstractParser.this.lexer.isAtEnd()) {
                    return;
                }
                if (this.spaceFirst && ((String)prefix).length() == 0 && !AbstractParser.this.lexer.isThereSpaceAfterCurrentToken()) {
                    AbstractParser.this.addCompletion(new DSLCompletion().setCompletion(new TokenSuggestion(" ")));
                } else {
                    if (((String)prefix).length() != 0 && AbstractParser.this.lexer.isThereSpaceAfterCurrentToken()) {
                        prefix = (String)prefix + " ";
                    }
                    for (PrefixCompleter completer : this.completers) {
                        AbstractParser.this.addCompletion(completer.complete((String)prefix));
                    }
                }
                if (this.throwException && AbstractParser.this.completions != null && AbstractParser.this.completions.size() > 0) {
                    throw new ParserCompletionException();
                }
            }
        }
    }
}

