/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

class UpgradeOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "upgrade";
    private static final long DEFAULT_TIMEOUT = 90L;
    private AbstractDSLOperation.ProgressMonitor progressMonitor;
    private FileWriter logWriter;
    private boolean shutdownInProgress;

    UpgradeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UPGRADE");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("TO").addParameter(this.makeVersionParameter(true))).setSyntaxHintSpace());
        this.syntax.addModifier(new Modifier("SHUTDOWN", false));
        this.syntax.addModifier((AbstractModifier)new Modifier("TIMEOUT", false).addParameter(new LongParameter("Timeout").setRange(10L, Long.MAX_VALUE)));
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false, (CompletionAdviser)new NodeCompletionAdviser()));
        this.syntax.setDescription("Upgrades the software to the specified version.\nIt shutdowns the mnode, extracts the image to $STROOT directory, launches the mnode and joins the sysplex.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  shutdown - Shutdowns Activator (for all management nodes in Sysplex) after extracting the image.\n             This mode is used if an upgrade of Activator itself is also required.\n             Management node should be launched manually in this case.\n  timeout  - Wait time (in seconds) for shutdown, launch and join the sysplex (separately for each operation).\n             Default value is 90 seconds. Minimal possible value is 10 seconds.\n  at node  - Executes this operation for the specified management node (it can be a current node).\n             Note that upgrading only one node can be dangerous because of possible incompatibility of different versions.");
        this.syntax.setExamples("upgrade to 3.5.008.55_jdk8\nupgrade to 3.5.008.55_jdk8 shutdown\nupgrade to 3.5.008.55_jdk8 timeout 60\nupgrade to 3.5.008.55_jdk8 at node Mnode2");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Version").getValue(), statement.existsModifier("SHUTDOWN"), statement.existsParameter("Timeout") ? Long.parseLong(statement.getParameter("Timeout").getValue()) : 90L, AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.shutdownInProgress = false;
        Definition definition = (Definition)statement;
        if (definition.nodeName != null && !definition.nodeName.equals(((Activator)this.callable).getNodeName()) && !((Activator)this.callable).getMnodeNames().contains(definition.nodeName)) {
            throw new FabricException(definition.nodeName + " is not a running Management Node.");
        }
        ((ActivatorMFSession)session).setBroadcastDefinition((AbstractActivatorOperation.BroadcastDefinition)statement);
        return this.invoke(definition.nodeName, definition, session, timeout);
    }

    @Override
    protected SLResponse invokeRemote(String nodeName, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        super.invokeRemote(nodeName, statement, session, timeout);
        Definition definition = (Definition)statement;
        if (definition.nodeName != null && !definition.nodeName.equals(((Activator)this.callable).getNodeName()) && ((ActivatorMFSession)session).getSessionId() != -1L) {
            this.raiseSLMessage("\n\nUpgrading node " + definition.nodeName + "...\n", session);
            this.raiseSLMessage("\nInformation about further steps will be available in the upgrade log.\n", session);
            return new SLResponse();
        }
        return new PseudoSLResponse();
    }

    @Override
    SLResponse invokeBroadcast(AbstractActivatorOperation.BroadcastDefinition definition, AbstractMFSession session, long timeout, String nodeName, SLResponse localResponse) throws Exception {
        this.invokeBroadcastCommand(definition, session, timeout);
        return new PseudoSLResponse();
    }

    @Override
    void prepare(AbstractActivatorOperation.BroadcastDefinition statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.raiseSLMessage("\nPreparing to upgrade...\n", session);
        Set<String> badNodes = this.checkImage(definition.nodeName, definition.version, session, timeout);
        if (!badNodes.isEmpty()) {
            throw new FabricException("Validating image archives failed.");
        }
        this.checkTnodes(definition.nodeName, session);
    }

    @Override
    SLResponse invokeLocal(AbstractActivatorOperation.BroadcastDefinition definition, AbstractMFSession session, long timeout) throws Exception {
        this.doUpgrade((Definition)definition, (ActivatorMFSession)session);
        return new PseudoSLResponse();
    }

    private void doUpgrade(Definition definition, ActivatorMFSession session) {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.Upgrade", "Upgrades the software.", () -> {
            try {
                Utils.sleep(500L);
                this.progressMonitor = new AbstractDSLOperation.ProgressMonitor(this, session);
                this.logWriter = new FileWriter(Activator.getUpgradeLogFile(definition.version));
                Activator.logInfo("Upgrading software to version " + definition.version + "...");
                this.raiseSLMessage("\n\nUpgrade started at " + Activator.DATE_FORMAT.format(new Date()) + ".\n", session);
                File image = Activator.getImageFile(definition.version);
                if (!image.exists()) {
                    this.processError("Image archive '" + image.getPath() + "' not found.", session, true);
                }
                this.shutdownMnode(definition, session);
                if (JVM.isWindowsOS()) {
                    super.raiseSLMessage("\n\nWARNING: Current session will be disconnected after shut down of Activator.\nInformation about further steps will be available in the Upgrade log.\n", session);
                    ((Activator)this.callable).startProcessInExtractMode(definition);
                } else {
                    this.extractImage(image, session);
                    if (definition.shutdown) {
                        this.shutdown(session);
                    } else {
                        this.launchMnode(definition, session);
                        this.joinSysplex(definition, session);
                    }
                    Activator.logInfo("Upgrade completed.");
                    this.raiseSLMessage("\n\nUpgrade completed at " + Activator.DATE_FORMAT.format(new Date()) + ".\n\n", session);
                    if (!definition.shutdown) {
                        this.raiseSLMessage(null, session);
                    }
                }
            }
            catch (Throwable exception) {
                Activator.logException(exception, "Upgrade failed.", true);
                this.raiseSLMessageError(Utils.formatException(exception, "\n       "), (MFSession)session);
                this.raiseSLMessage(null, session);
            }
            finally {
                if (this.progressMonitor != null) {
                    this.progressMonitor.stop();
                    this.progressMonitor = null;
                }
                if (this.logWriter != null) {
                    try {
                        this.logWriter.close();
                    }
                    catch (IOException image) {}
                    this.logWriter = null;
                }
            }
        }).start();
    }

    private void shutdownMnode(Definition definition, ActivatorMFSession session) throws Exception {
        if (session.getSessionId() == -1L && session.definition.isBroadcast()) {
            super.raiseSLMessage("\nWARNING: Current session will be disconnected after shut down of Management Node.\nInformation about further steps will be available in the Upgrade log.\n", session);
        }
        Activator.logInfo("Shutting down Management Node...");
        this.raiseSLMessage("\nShutting down Management Node...", session);
        if (!definition.isBroadcast() && this.isTargetNode(definition)) {
            super.raiseSLMessage("\n\nInformation about further steps will be available in the Upgrade log.\n", session);
            super.raiseSLMessage(null, session);
            Utils.sleep(100L);
        }
        try {
            this.shutdownInProgress = true;
            this.progressMonitor.start();
            ((Activator)this.callable).shutdownMnodeWithWait(false, definition.timeout * 1000L);
            this.progressMonitor.sleep();
            this.raiseOK(session);
            Utils.sleep(500L);
        }
        finally {
            this.shutdownInProgress = false;
        }
    }

    private void extractImage(File image, ActivatorMFSession session) throws Exception {
        File stroot = new File(System.getenv("STROOT"));
        Activator.logInfo("Extracting image '" + image.getName() + "' to '" + stroot.getAbsolutePath() + "'...");
        this.raiseSLMessage("\n\nExtracting image to '" + stroot.getAbsolutePath() + "'...", session);
        this.progressMonitor.wakeUp();
        Activator.extractImage(image, stroot, this.logWriter);
        this.progressMonitor.sleep();
        this.raiseOK(session);
    }

    private void launchMnode(Definition definition, ActivatorMFSession session) throws Exception {
        this.raiseSLMessage("\n\nLaunching Management Node...", session);
        this.progressMonitor.wakeUp();
        ((Activator)this.callable).startMnodeForUpgrade(definition.timeout * 1000L);
        this.progressMonitor.sleep();
        this.raiseSLMessage(" OK", session);
    }

    private void joinSysplex(Definition definition, ActivatorMFSession session) throws Exception {
        Activator.logInfo("Joining sysplex...");
        this.raiseSLMessage("\n\nJoining Sysplex...", session);
        this.progressMonitor.wakeUp();
        Utils.sleep(5000L);
        ((Activator)this.callable).invokeMNodeRequest(6, session, definition.timeout * 1000L);
        this.progressMonitor.sleep();
        this.raiseSLMessage(" OK", session);
    }

    private void shutdown(ActivatorMFSession session) {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.Shutdown", "Shutdown Activator.", () -> {
            Utils.sleep(500L);
            this.raiseSLMessage("\nShutting down...\n", session);
            this.raiseSLMessage(null, session);
            Utils.sleep(500L);
            ((Activator)this.callable).shutdown(false);
        }).start();
    }

    private void processError(String message, ActivatorMFSession session, boolean withException) throws Exception {
        this.raiseSLMessageError(message, (MFSession)session);
        if (withException) {
            throw new FabricException(message);
        }
    }

    @Override
    protected void raiseSLMessage(String message, MFSession session) {
        if (this.canRaiseSLMessage(session)) {
            super.raiseSLMessage(message, session);
        }
        this.writeInLog(message);
    }

    @Override
    protected void raiseSLMessageError(String message, MFSession session) {
        if (this.canRaiseSLMessage(session)) {
            super.raiseSLMessageError(message, session);
        }
        this.writeInLog("\nERROR: " + message + "\n");
    }

    private boolean canRaiseSLMessage(MFSession session) {
        Definition definition = (Definition)((ActivatorMFSession)session).definition;
        return definition.isBroadcast() || this.isTargetNode(definition) && !this.shutdownInProgress;
    }

    private void writeInLog(String message) {
        try {
            if (this.logWriter != null && message != null) {
                this.logWriter.write(message);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isTargetNode(Definition definition) {
        return definition.nodeName != null && definition.nodeName.equals(((Activator)this.callable).getNodeName());
    }

    private class NodeCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<Activator> {
        private NodeCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                ArrayList<String> result = new ArrayList<String>();
                result.add(((Activator)UpgradeOperation.this.callable).getNodeName());
                result.addAll(((Activator)UpgradeOperation.this.callable).getMnodeNames());
                return result;
            }
            catch (Exception exception) {
                return new ArrayList<String>();
            }
        }
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        String version;
        boolean shutdown;
        long timeout;
        String nodeName;

        Definition(String version, boolean shutdown, long timeout, String nodeName) {
            super(UpgradeOperation.NAME, true, true);
            this.version = version;
            this.shutdown = shutdown;
            this.timeout = timeout;
            this.nodeName = nodeName;
        }
    }
}

