/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SyncDepotImageOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "sync depot image";

    SyncDepotImageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SYNC DEPOT IMAGE");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier((AbstractModifier)new Modifier().addParameter(this.makeVersionParameter(true)))).addModifier((AbstractModifier)new Modifier("ALL").setAlias("*"))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false, (CompletionAdviser)new NodeCompletionAdviser()));
        this.syntax.setDescription("sync depot image <Version> - Synchronizes the specified image over all management nodes in the sysplex.\nsync depot image all       - Synchronizes all images stored in the depot over all management nodes in the sysplex.\n");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  at node <NodeName> - Executes this operation for the specified management node (it should not be a current node).");
        this.syntax.setExamples("sync depot image 3.6.005.35_jdk8\nsync depot image all\nsync depot image 3.6.005.35_jdk8 at node Mnode2");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("Version") ? statement.getParameter("Version").getValue() : "*", AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (!((Activator)this.callable).isMnodeConnected()) {
            throw new FabricException("Connection with managed node is not established.");
        }
        if (definition.nodeName != null) {
            if (definition.nodeName.equals(((Activator)this.callable).getNodeName())) {
                throw new FabricException(definition.nodeName + " is a current node.");
            }
            if (!((Activator)this.callable).getMnodeNames().contains(definition.nodeName)) {
                throw new FabricException(definition.nodeName + " is not a running management node.");
            }
        }
        this.doSync(definition.nodeName, (ActivatorMFSession)session, timeout, this.listImageVersions(definition));
        return new PseudoSLResponse();
    }

    private List<String> listImageVersions(Definition definition) {
        return definition.version.equals("*") ? ((Activator)this.callable).listImageVersions() : Arrays.asList(definition.version);
    }

    private void doSync(String nodeName, ActivatorMFSession session, long timeout, List<String> versions) throws Exception {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.SyncImage", "Synchronizes depot images.", () -> {
            Utils.sleep(500L);
            Map<String, Activator.ImageData> images = this.checkImages(nodeName, session, timeout, versions);
            if (images.isEmpty()) {
                this.raiseSLMessage("\nAll is up to date. Synchronization not needed.\n", session);
                this.raiseSLMessage(null, session);
            } else {
                try {
                    if (!this.uploadImageToMnodes(session, images, false, timeout)) {
                        this.raiseSLMessageError("Connection to managed node closed. Synchronization failed.", (MFSession)session);
                        this.raiseSLMessage(null, session);
                    }
                }
                catch (Throwable exception) {
                    this.raiseSLMessageError(exception.getMessage(), (MFSession)session);
                    this.raiseSLMessage(null, session);
                }
            }
        }).start();
    }

    private Map<String, Activator.ImageData> checkImages(String nodeName, ActivatorMFSession session, long timeout, List<String> versions) {
        HashMap<String, Activator.ImageData> result = new HashMap<String, Activator.ImageData>();
        for (String version : versions) {
            try {
                this.raiseSLMessage("\n", session);
                Set<String> nodes = this.checkImage(nodeName, version, session, timeout);
                if (nodes.isEmpty()) continue;
                result.put(version, new Activator.ImageData(Activator.getImageFile(version).getPath(), nodes));
            }
            catch (Throwable exception) {
                this.raiseSLMessage("\nWARNING: " + Utils.formatException(exception, "\n       ") + "\n", session);
            }
        }
        return result;
    }

    @Override
    protected String getBroadcastResponsePrefix() {
        return "Sync at";
    }

    private class NodeCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<Activator> {
        private NodeCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            try {
                return ((Activator)SyncDepotImageOperation.this.callable).getMnodeNames();
            }
            catch (Exception exception) {
                return new ArrayList<String>();
            }
        }
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        private String version;
        private String nodeName;

        Definition(String version, String nodeName) {
            super(SyncDepotImageOperation.NAME, true);
            this.version = version;
            this.nodeName = nodeName;
        }
    }
}

