/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractStartStopMnodeOperation;
import com.streamscape.tools.mnode.activator.Activator;

class StopMnodeOperation
extends AbstractStartStopMnodeOperation {
    public static final String NAME = "stop mnode";
    static final long DEFAULT_TIMEOUT = 30L;
    static final String OPERATION_MESSAGE = "Shutting down management node";

    StopMnodeOperation() {
        super(NAME);
        this.syntax.addModifier((AbstractModifier)new Modifier("FORCE", false).setSyntaxHintSpace());
        this.syntax.setDescription("Stops the associated management node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   timeout <Timeout> - Wait time (in seconds) for shutdown of the mnode.\n                       Default timeout is 30 seconds. Minimal possible value is 10 seconds.\n   force             - Tries to stop the mnode forcibly (kill its process).");
        this.syntax.setExamples("stop mnode\nstop mnode timeout 60\nstop mnode force");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getTimeout(statement, 30L), statement.existsModifier("FORCE"));
    }

    @Override
    String getThreadName() {
        return "FSYS:Activator.StopMnode";
    }

    @Override
    String getThreadDescription() {
        return "Stops the management node.";
    }

    @Override
    void doOperation(SLStatement statement, MFSession session) throws Exception {
        this.doOperation(statement, session, OPERATION_MESSAGE, () -> StopMnodeOperation.doOperation((Activator)this.callable, statement));
    }

    static void doOperation(Activator callable, SLStatement statement) throws Exception {
        callable.stopMnode(((AbstractStartStopMnodeOperation.AbstractDefinition)statement).force, ((AbstractStartStopMnodeOperation.AbstractDefinition)statement).timeout * 1000L);
    }

    static class Definition
    extends AbstractStartStopMnodeOperation.AbstractDefinition {
        Definition(long timeout, boolean force) {
            super(StopMnodeOperation.NAME, timeout, force);
        }
    }
}

