/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.tools.mnode.activator.AbstractStartStopMnodeOperation;
import com.streamscape.tools.mnode.activator.Activator;

class StartMnodeOperation
extends AbstractStartStopMnodeOperation {
    public static final String NAME = "start mnode";
    static final long DEFAULT_TIMEOUT = 90L;
    static final String OPERATION_MESSAGE = "Launching management node";

    StartMnodeOperation() {
        super(NAME);
        this.syntax.setDescription("Starts the associated management node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   timeout <Timeout> - Wait time (in seconds) for launch of the mnode.\n                       Default timeout is 90 seconds. Minimal possible value is 10 seconds.");
        this.syntax.setExamples("start mnode\nstart mnode timeout 180");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getTimeout(statement, 90L));
    }

    @Override
    String getThreadName() {
        return "FSYS:Activator.StartMnode";
    }

    @Override
    String getThreadDescription() {
        return "Starts the management node.";
    }

    @Override
    void doOperation(SLStatement statement, MFSession session) throws Exception {
        this.doOperation(statement, session, OPERATION_MESSAGE, () -> StartMnodeOperation.doOperation((Activator)this.callable, statement));
    }

    static void doOperation(Activator callable, SLStatement statement) throws Exception {
        callable.startMnode(false, ((AbstractStartStopMnodeOperation.AbstractDefinition)statement).timeout * 1000L);
    }

    static class Definition
    extends AbstractStartStopMnodeOperation.AbstractDefinition {
        Definition(long timeout) {
            super(StartMnodeOperation.NAME, timeout, false);
        }
    }
}

