/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.Activator;

class ShutdownOperation
extends AbstractActivatorOperation {
    public static final String NAME = "shutdown";

    ShutdownOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHUTDOWN");
        this.syntax.addModifier((AbstractModifier)new Modifier("ALL", false).setSyntaxHintSpace());
        this.syntax.setDescription("Initiates shutdown of the node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all - Also shutdowns the associated management node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        FabricThreadManager.getInstance().createThread("FSYS:Activator.Shutdown", "Shutdowns the Activator.", () -> {
            Utils.sleep(500L);
            ((Activator)this.callable).shutdown(((Definition)statement).all);
        }).start();
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private boolean all = false;

        Definition(boolean all) {
            super(ShutdownOperation.NAME);
            this.all = all;
        }

        public boolean isAll() {
            return this.all;
        }
    }
}

