/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.io.File;

class ShowUpgradeLogOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "show upgrade log";

    ShowUpgradeLogOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW UPGRADE LOG");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR").addParameter(this.makeVersionParameter(true))).setSyntaxHintSpace());
        this.syntax.setDescription("Shows a log of the latest Upgrade operation for the specified version.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Version").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke((Definition)statement, session, timeout);
    }

    @Override
    void prepare(AbstractActivatorOperation.BroadcastDefinition statement, AbstractMFSession session, long timeout) throws Exception {
        File imageDir = Activator.getImageDir(((Definition)statement).version);
        if (!imageDir.exists()) {
            throw new FabricException("Image not found in depot.");
        }
    }

    @Override
    SLResponse invokeLocal(AbstractActivatorOperation.BroadcastDefinition definition, AbstractMFSession session, long timeout) throws Exception {
        Activator cfr_ignored_0 = (Activator)this.callable;
        File logFile = Activator.getUpgradeLogFile(((Definition)definition).version);
        return logFile.exists() ? new SLResponse(new String(FileIOUtils.getFileContent(logFile))) : new SLResponse();
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowUpgradeLogOperation.addColumn(result, "Log");
        return result;
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        private String version;

        Definition(String version) {
            super(ShowUpgradeLogOperation.NAME, true, true);
            this.version = version;
        }
    }
}

