/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.util.HashMap;
import java.util.Map;

class SetLogMonitorPropertiesOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "set log monitor properties";
    public static final String NAME_PARAMETER = "configurationName";
    public static final String URL_PARAMETER = "url";
    public static final String USER_PARAMETER = "user";
    public static final String PASSWORD_PARAMETER = "password";
    public static final String RECONNECT_ATTEMPTS_PARAMETER = "reconnectAttempts";
    public static final String RECONNECT_INTERVAL_PARAMETER = "reconnectInterval";
    public static final String EVENT_SCOPE_PARAMETER = "eventScope";
    public static final String NO_LOCAL_PARAMETER = "noLocal";
    public static final String AUTO_START_PARAMETER = "autoStart";

    public SetLogMonitorPropertiesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET LOG MONITOR PROPERTIES");
        this.syntax.addModifier((AbstractModifier)new SetParametersModifier("", "Properties").setSyntaxHint(SyntaxHint.SPACE));
        this.addAtDomainModifier();
        this.syntax.setDescription("Sets the specified configuration properties of the Log Monitor.");
        this.syntax.setSyntaxDescription("set log monitor properties           - Sets the specified properties in the current Log Monitor.\nset log monitor properties at domain - Sets the specified properties globally in all Log Monitors of the sysplex.\n\nThe following properties are supported:\n\n   url               - Forwarding URL of the target system used for machine data collections and analysis.\n   user              - User name that is used to connect to the target system.\n   password          - User password that is used to connect to the target system.\n   reconnectAttempts - Number of reconnect attempts to the target system after connection break.\n                       Negative value means that a number of reconnect attempts is not limited (until successful connecting).\n                       Default value is -1.\n   reconnectInterval - Time (in seconds) between successive reconnect attempts to the target system after connection break.\n                       Default value is 30 seconds.\n   configurationName - Name of the monitor configuration that will be obtained from the target system.\n                       Default value is <Domain>-<MNodeName> (e.g. Domain1-MNode1).\n   eventScope        - Scope of Log Event that is sent by Log Monitor.\n                       Possible values are OBSERVABLE and GLOBAL. Default value is GLOBAL.\n   noLocal           - Specifies if Log Monitor should send Log Events to the target system only.\n                       If the value is false, Log Monitor will send the events to the local Management Node.\n                       Default value is true.\n   autoStart         - Specifies if Log Monitor should be automatically started during start-up of Activator.");
        this.syntax.setExamples("set log monitor properties (url = 'tlp://localhost:5555', user = 'Admin', password = 'Admin')\nset log monitor properties (autoStart = 'true') at domain\nset log monitor properties (eventScope = 'OBSERVABLE')\nset log monitor properties (noLocal = 'false')");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.atDomain(statement), SetParametersModifier.getValue(statement, "Properties"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke((Definition)statement, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(AbstractActivatorOperation.BroadcastDefinition definition, AbstractMFSession session, long timeout) throws Exception {
        LogMonitor monitor = this.getLogMonitor();
        HashMap<String, String> properties = new HashMap<String, String>(((Definition)definition).properties);
        if (properties.containsKey(AUTO_START_PARAMETER)) {
            monitor.setAutoStart(SetParametersModifier.getBoolean(AUTO_START_PARAMETER, (String)properties.remove(AUTO_START_PARAMETER)));
        }
        if (!properties.isEmpty()) {
            LogEventForwarderConfiguration forwarderConfig = null;
            if ((properties.containsKey(NAME_PARAMETER) || properties.containsKey(URL_PARAMETER) || properties.containsKey(USER_PARAMETER) || properties.containsKey(PASSWORD_PARAMETER) || properties.containsKey(RECONNECT_ATTEMPTS_PARAMETER) || properties.containsKey(RECONNECT_INTERVAL_PARAMETER) || properties.containsKey(EVENT_SCOPE_PARAMETER) || properties.containsKey(NO_LOCAL_PARAMETER)) && (forwarderConfig = monitor.getForwarderConfiguration()) == null) {
                forwarderConfig = monitor.createForwarderConfigurationInstance();
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (((String)entry.getKey()).equals(NAME_PARAMETER)) {
                    forwarderConfig.setName((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(URL_PARAMETER)) {
                    forwarderConfig.setUrl((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(USER_PARAMETER)) {
                    forwarderConfig.setUserName((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(PASSWORD_PARAMETER)) {
                    forwarderConfig.setPassword((String)entry.getValue());
                    continue;
                }
                if (((String)entry.getKey()).equals(RECONNECT_ATTEMPTS_PARAMETER)) {
                    forwarderConfig.setReconnectAttempts(SetParametersModifier.getInt(RECONNECT_ATTEMPTS_PARAMETER, (String)entry.getValue()));
                    continue;
                }
                if (((String)entry.getKey()).equals(RECONNECT_INTERVAL_PARAMETER)) {
                    forwarderConfig.setReconnectInterval(SetParametersModifier.getLong(RECONNECT_INTERVAL_PARAMETER, (String)entry.getValue()));
                    continue;
                }
                if (((String)entry.getKey()).equals(EVENT_SCOPE_PARAMETER)) {
                    forwarderConfig.setEventScope(EventScope.valueOf((String)entry.getValue()));
                    continue;
                }
                if (((String)entry.getKey()).equals(NO_LOCAL_PARAMETER)) {
                    forwarderConfig.setNoLocal(SetParametersModifier.getBoolean(NO_LOCAL_PARAMETER, (String)entry.getValue()));
                    continue;
                }
                throw new FabricException("Unknown parameter '" + (String)entry.getKey() + "'.");
            }
            if (forwarderConfig != null) {
                ((Activator)this.callable).checkName(forwarderConfig);
                monitor.setForwarderConfiguration(forwarderConfig);
            }
        }
        return new SLResponse();
    }

    private static ThreadPoolType getPoolType(String name, String value) throws Exception {
        try {
            return ThreadPoolType.valueOf(value);
        }
        catch (Exception exception) {
            throw new FabricException("Invalid value '" + value + "' for property '" + name + "'.");
        }
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        private Map<String, String> properties;

        Definition(boolean broadcast, Map<String, String> properties) {
            super(SetLogMonitorPropertiesOperation.NAME, broadcast);
            this.properties = properties;
        }

        public Map<String, String> getProperties() {
            return new HashMap<String, String>(this.properties);
        }
    }
}

