/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LongParameter;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.StartTnodesOperation;
import com.streamscape.tools.mnode.activator.StopTnodesOperation;

class RestartTnodesOperation
extends AbstractActivatorOperation {
    public static final String NAME = "restart tnodes";

    RestartTnodesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("RESTART TNODES").setAlias("RESTART TASK NODES");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("STOP TIMEOUT", false).addParameter(new LongParameter("StopTimeout"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("START TIMEOUT", false).addParameter(new LongParameter("StartTimeout"))).setSyntaxHintSpace());
        this.syntax.setDescription("Restarts all task nodes in the sysplex.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  stop timeout  - Wait time (in seconds) for shutdown of a single task node.\n                  Default is 20 seconds.\n  start timeout - Wait time (in seconds) for starting of a single task node.\n                  Default is 180 seconds.\n");
        this.syntax.setExamples("restart tnodes\nrestart task nodes stop timeout 30 start timeout 60");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("StopTimeout") ? Long.parseLong(statement.getParameter("StopTimeout").getValue()) : 20L, statement.existsParameter("StartTimeout") ? Long.parseLong(statement.getParameter("StartTimeout").getValue()) : 180L);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SLResponse stopResponse = StopTnodesOperation.doInvoke((Activator)this.callable, session, timeout, definition.stopTimeout, true);
        if (!stopResponse.isOK()) {
            return stopResponse;
        }
        return StartTnodesOperation.doInvoke((Activator)this.callable, session, timeout, definition.startTimeout);
    }

    static class Definition
    extends AbstractSLStatement {
        long stopTimeout = 20L;
        long startTimeout = 180L;

        Definition(long stopTimeout, long startTimeout) {
            super(RestartTnodesOperation.NAME);
            this.stopTimeout = stopTimeout;
            this.startTimeout = startTimeout;
        }
    }
}

