/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.mnode.activator.AbstractStartStopMnodeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.StartMnodeOperation;
import com.streamscape.tools.mnode.activator.StopMnodeOperation;

class RestartMnodeOperation
extends AbstractStartStopMnodeOperation {
    public static final String NAME = "restart mnode";
    private static final long DEFAULT_TIMEOUT = 90L;

    RestartMnodeOperation() {
        super(NAME);
        this.syntax.addModifier((AbstractModifier)new Modifier("FORCE", false).setSyntaxHintSpace());
        this.syntax.setDescription("Restarts the associated management node.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   timeout <Timeout> - Wait time (in seconds) for shutdown and launch of the mnode (separately for each operation).\n                       Default timeout is 90 seconds. Minimal possible value is 10 seconds.\n   force             - Tries to stop the mnode forcibly (kill its process).");
        this.syntax.setExamples("restart mnode\nrestart mnode timeout 180\nrestart mnode force");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getTimeout(statement, 90L), statement.existsModifier("FORCE"));
    }

    @Override
    String getThreadName() {
        return "FSYS:Activator.RestartMnode";
    }

    @Override
    String getThreadDescription() {
        return "Restarts the management node.";
    }

    @Override
    void doOperation(SLStatement statement, MFSession session) throws Exception {
        this.doOperation(statement, session, "Shutting down management node", () -> StopMnodeOperation.doOperation((Activator)this.callable, statement));
        Utils.sleep(100L);
        this.doOperation(statement, session, "Launching management node", () -> StartMnodeOperation.doOperation((Activator)this.callable, statement));
    }

    static class Definition
    extends AbstractStartStopMnodeOperation.AbstractDefinition {
        Definition(long timeout, boolean force) {
            super(RestartMnodeOperation.NAME, timeout, force);
        }
    }
}

