/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

class RemoveLogEventSourceOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "remove log event source";

    RemoveLogEventSourceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE LOG EVENT SOURCE");
        this.syntax.addModifier((AbstractModifier)new Modifier("type").addParameter((SyntaxParameter)new IdentifierParameter("SourceType").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<Activator>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                Set result = new TreeSet();
                try {
                    result = RemoveLogEventSourceOperation.this.getLogMonitor().getConfiguration().getSources().stream().map(LogEventSource::getSourceType).collect(Collectors.toCollection(TreeSet::new));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new ArrayList<String>(result);
            }
        })));
        this.syntax.addModifier(((ChoiceModifier)new ChoiceModifier().addModifier((AbstractModifier)new Modifier("NAME").addParameter((SyntaxParameter)new IdentifierParameter("SourceName").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<Activator>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                int endIndex;
                String sourceType = null;
                String script = processedScript.toLowerCase();
                int startIndex = processedScript.indexOf("type");
                if (startIndex != -1 && (endIndex = processedScript.indexOf("name")) != -1) {
                    sourceType = processedScript.substring(startIndex + 5, endIndex).trim();
                }
                Set result = new TreeSet();
                if (sourceType != null) {
                    try {
                        String type = AbstractLogMonitorOperation.convertSourceType(sourceType);
                        result = RemoveLogEventSourceOperation.this.getLogMonitor().getConfiguration().getSources().stream().filter(source -> source.getSourceType().equals(type)).map(LogEventSource::getSourceName).collect(Collectors.toCollection(TreeSet::new));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new ArrayList<String>(result);
            }
        })))).addPossibleValue("ALL"));
        this.syntax.setDescription("Remove the specified log event source from configuration of Log Monitor.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   type   - Type of the source.\n   name   - Name of the source.\n   all    - Automatically removes all possible sources with the specified source type.\n");
        this.syntax.setExamples("remove log event source type TASK_NODE name Node1\nremove log event source type TASK_NODE all");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(RemoveLogEventSourceOperation.getSourceType(statement), statement.existsParameter("SourceName") ? statement.getParameter("SourceName").getValue() : null, statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        LogMonitor monitor = this.getLogMonitor();
        if (definition.all) {
            monitor.removeSources(definition.sourceType);
        } else {
            if (!monitor.existsSource(definition.sourceType, definition.sourceName)) {
                throw new FabricException("Source not found.");
            }
            monitor.removeSource(definition.sourceType, definition.sourceName);
        }
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String sourceType;
        private String sourceName;
        private boolean all;

        Definition(String sourceType, String sourceName, boolean all) {
            super(RemoveLogEventSourceOperation.NAME);
            this.sourceType = sourceType;
            this.sourceName = sourceName;
            this.all = all;
        }

        String getSourceType() {
            return this.sourceType;
        }

        String getSourceName() {
            return this.sourceName;
        }

        boolean isAll() {
            return this.all;
        }
    }
}

