/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.util.ArrayList;
import java.util.List;

class RemoveExternalLogEventTypeOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "remove external log event type";

    RemoveExternalLogEventTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE EXTERNAL LOG EVENT TYPE");
        this.syntax.addActionParameter((SyntaxParameter)new IdentifierParameter("SourceType").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<Activator>(){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                try {
                    return RemoveExternalLogEventTypeOperation.this.getLogMonitor().getConfiguration().getExternalSourceTypes();
                }
                catch (FabricException fabricException) {
                    return new ArrayList<String>();
                }
            }
        }));
        this.syntax.setDescription("Removes the specified external Log Event source type from the configuration of Log Monitor.\nSource types are case-sensitive.");
        this.syntax.setExamples("remove external log event type TestType");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("SourceType").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        LogMonitor monitor = this.getLogMonitor();
        if (!monitor.existsExternalSourceType(definition.type)) {
            throw new FabricException("Source type not found.");
        }
        monitor.removeExternalSourceType(definition.type);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String type;

        Definition(String type) {
            super(RemoveExternalLogEventTypeOperation.NAME);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

