/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ImageManifest;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class ListDepotImagesOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "list depot images";

    ListDepotImagesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST DEPOT IMAGES");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier((AbstractModifier)new Modifier("LIKE").addParameter((SyntaxParameter)new StringParameter("Filter").setName("LikePattern")))).addModifier((AbstractModifier)new Modifier("MATCHES").addParameter((SyntaxParameter)new StringParameter("Filter").setName("MatchesPattern"))));
        this.syntax.setDescription("Shows a list of images stored in the depot.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   like <Filter> - Shows a list of images whose version matches the specified filter.\n                   Parameter <Filter> should be put in quotes. It is a standard Java regular expression.\n                   Keyword MATCHES can be used instead of LIKE.");
        this.syntax.setExamples("list depot images\nlist depot images like '3.6.*'\nlist depot images matches '.*005.*'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsParameter("LikePattern") ? statement.getParameter("LikePattern").getValue() : (statement.existsParameter("MatchesPattern") ? statement.getParameter("MatchesPattern").getValue() : null));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListDepotImagesOperation.createResultDescriptor());
        for (String version : this.listImageVersions((Definition)statement)) {
            ImageManifest manifest = Activator.getImageManifest(version);
            result.addToRowSet(new Object[]{version, this.getValue("ReleaseDate", manifest), this.getValue("Version", manifest), this.getValue("Build", manifest), this.getValue("Platform", manifest), this.getValue("JDK", manifest), this.getValue("ImportDate", manifest), this.getValue("Archive", manifest)});
        }
        return new SLResponse(result);
    }

    private List<String> listImageVersions(Definition definition) throws Exception {
        if (definition.filter != null) {
            Pattern pattern = ListDepotImagesOperation.compilePattern(definition.filter);
            return ((Activator)this.callable).listImageVersions().stream().filter(version -> pattern.matcher((CharSequence)version).matches()).collect(Collectors.toList());
        }
        return ((Activator)this.callable).listImageVersions();
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListDepotImagesOperation.addColumn(result, "Name");
        ListDepotImagesOperation.addColumn(result, "Release Date");
        ListDepotImagesOperation.addColumn(result, "Version");
        ListDepotImagesOperation.addColumn(result, "Build");
        ListDepotImagesOperation.addColumn(result, "Platform");
        ListDepotImagesOperation.addColumn(result, "JDK");
        ListDepotImagesOperation.addColumn(result, "ImportDate");
        ListDepotImagesOperation.addColumn(result, "Archive");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private String filter;

        Definition(String filter) {
            super(ListDepotImagesOperation.NAME);
            this.filter = filter;
        }
    }
}

