/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import com.streamscape.tools.mnode.activator.ActivatorSLFileUtilsFactory;
import com.streamscape.tools.mnode.activator.ImageManifest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

class ImportDepotImageOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "import depot image";

    ImportDepotImageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("IMPORT DEPOT IMAGE");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FROM").addParameter(new SLFilePathParameter("Path"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH WAIT", false).setName("WithWait"));
        this.syntax.setDescription("Uploads a new image taken by the specified path into the depot.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   from      - Path to the location where the image will be imported from.\n\nOptional parameters:\n\n   with wait - Executes this operation in synchronous mode (waits for completion or expiring reply timeout).");
        this.syntax.setExamples("import depot image from 'C:/StreamScape/1.8/STRuntime_FCS_3.6.005.35_jdk8_win.zip'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Path").getValue(), statement.existsModifier("WithWait"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Activator.checkImageFullFileExtension(definition.path);
        if (definition.withWait) {
            this.doInvoke(definition, (ActivatorMFSession)session, timeout);
            return new SLResponse();
        }
        FabricThreadManager.getInstance().createThread("FSYS:Activator.ImportImage", "Imports the depot image.", () -> {
            Utils.sleep(500L);
            try {
                if (!this.doInvoke(definition, (ActivatorMFSession)session, timeout)) {
                    this.raiseSLMessage(null, session);
                }
            }
            catch (Throwable exception2) {
                FabricException exception2;
                Activator.logException(exception2, "Importing image failed.", true);
                if (exception2 instanceof FileNotFoundException) {
                    exception2 = new FabricException("File '" + exception2.getMessage() + "' not found.");
                }
                this.raiseSLMessageError(exception2, session);
                this.raiseSLMessage(null, session);
            }
        }).start();
        return new PseudoSLResponse();
    }

    private boolean doInvoke(Definition definition, ActivatorMFSession session, long timeout) throws Exception {
        this.downloadImage(definition, session);
        return this.uploadImageToMnodes(session, this.makeMap(definition), definition.withWait, timeout);
    }

    private void downloadImage(Definition definition, ActivatorMFSession session) throws Exception {
        String tmpVersion = UUID.randomUUID().toString();
        String tmpImageFilename = Activator.makeFullFilename(tmpVersion);
        File tmpImageDir = Activator.getImageDir(tmpVersion);
        tmpImageDir.mkdirs();
        this.raiseSLMessage("\nUploading image...\n\n", session);
        File tmpImageFile = new File(tmpImageDir, tmpImageFilename);
        try (FileOutputStream outputStream = new FileOutputStream(tmpImageFile);){
            ((SLFileUtils)new ActivatorSLFileUtilsFactory((Activator)this.callable).create(session, definition.path)).readFile(outputStream);
            this.raiseSLMessage("\nImage uploaded.\n", session);
            this.raiseSLMessage("\nValidating image...", session);
            ImageManifest manifest = Activator.completeImage(null, tmpImageFile, false);
            definition.version = manifest.getProperty("Name");
            this.raiseSLMessage(" OK", session);
            this.raiseSLMessage(this.getImageInfo(definition.version, manifest), session);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof Exception) {
                throw (Exception)exception.getCause();
            }
            throw exception;
        }
        finally {
            FileIOUtils.deleteFileDir(tmpImageDir);
        }
    }

    private Map<String, Activator.ImageData> makeMap(Definition definition) {
        HashMap<String, Activator.ImageData> result = new HashMap<String, Activator.ImageData>();
        result.put(definition.version, new Activator.ImageData(Activator.getImageFile(definition.version).getPath(), null));
        return result;
    }

    @Override
    protected String getBroadcastResponsePrefix() {
        return "Import to";
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        private String path;
        private String version;
        private boolean withWait = false;

        Definition(String path, boolean withWait) {
            super(ImportDepotImageOperation.NAME, true, true);
            this.path = path;
            this.withWait = withWait;
        }
    }
}

