/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.tools.log.monitor.LogEventForwarderConfiguration;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.LogMonitorConfiguration;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import java.util.Date;
import java.util.Map;

class DescribeLogMonitorOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "describe log monitor";

    DescribeLogMonitorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE LOG MONITOR");
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier(false).addPossibleValues("SOURCES", "SOURCE TYPES", "PROPERTIES").setSyntaxHintSpace());
        this.syntax.setDescription("Shows information about Log Monitor.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   sources      - Shows information about all Log Event Sources of Log Monitor.\n   source types - Shows a list of all Log Event Source Types of Log Monitor.\n   properties   - Shows information about all properties containing in Log Monitor configuration.");
        this.syntax.setExamples("describe log monitor\ndescribe log monitor sources\ndescribe log monitor source types\ndescribe log monitor properties");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Option option = null;
        if (statement.existsModifier("SOURCES")) {
            option = Option.SOURCES;
        } else if (statement.existsModifier("SOURCE TYPES")) {
            option = Option.SOURCE_TYPES;
        } else if (statement.existsModifier("PROPERTIES")) {
            option = Option.PROPERTIES;
        }
        return new Definition(option);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        LogMonitor monitor = this.getLogMonitor();
        RowSet result = new RowSet(DescribeLogMonitorOperation.createResultDescriptor(definition.option));
        if (definition.option == Option.SOURCES) {
            LogMonitorConfiguration configuration = monitor.getConfiguration();
            if (configuration != null) {
                for (LogEventSource source : configuration.getSources()) {
                    result.addToRowSet(new Object[]{source.getSourceType(), source.getSourceName(), DescribeLogMonitorOperation.skipNull(source.getLogFilename()), source.isLogFileFound(), source.getLinesOffset(), source.isValid(), DescribeLogMonitorOperation.skipNull(source.getError())});
                }
            }
        } else if (definition.option == Option.SOURCE_TYPES) {
            result.addToRowSet(new Object[]{FabricNodeRole.MANAGEMENT_NODE.name(), "Internal"});
            result.addToRowSet(new Object[]{FabricNodeRole.TASK_NODE.name(), "Internal"});
            LogMonitorConfiguration configuration = monitor.getConfiguration();
            if (configuration != null) {
                for (String type : configuration.getExternalSourceTypes()) {
                    result.addToRowSet(new Object[]{type, "External"});
                }
            }
        } else if (definition.option == Option.PROPERTIES) {
            LogMonitorConfiguration configuration = monitor.getConfiguration();
            if (configuration != null) {
                for (Map.Entry<String, String> entry : configuration.getProperties().entrySet()) {
                    result.addToRowSet(new Object[]{entry.getKey(), entry.getValue()});
                }
            }
        } else {
            LogMonitorConfiguration configuration;
            LogEventForwarderConfiguration forwarderConfiguration = monitor.getForwarderConfiguration();
            if (forwarderConfiguration != null) {
                result.addToRowSet(new Object[]{"Configuration Name", forwarderConfiguration.getName()});
                result.addToRowSet(new Object[]{"Target System URL", DescribeLogMonitorOperation.skipNull(forwarderConfiguration.getUrl())});
                result.addToRowSet(new Object[]{"Target System User", DescribeLogMonitorOperation.skipNull(forwarderConfiguration.getUserName())});
                result.addToRowSet(new Object[]{"Reconnect Attempts", forwarderConfiguration.getReconnectAttempts()});
                result.addToRowSet(new Object[]{"Reconnect Interval", forwarderConfiguration.getReconnectInterval()});
                result.addToRowSet(new Object[]{"Event Scope", forwarderConfiguration.getEventScope()});
                result.addToRowSet(new Object[]{"No Local", forwarderConfiguration.isNoLocal()});
            }
            if ((configuration = monitor.getConfiguration()) != null) {
                if (forwarderConfiguration == null) {
                    result.addToRowSet(new Object[]{"Configuration Name", configuration.getName()});
                }
                result.addToRowSet(new Object[]{"Log Sources", configuration.hasSources() ? configuration.getSources().size() : 0});
                result.addToRowSet(new Object[]{"Properties", configuration.hasProperties() ? configuration.getProperties().size() : 0});
            } else {
                result.addToRowSet(new Object[]{"Configuration", "n/a"});
            }
            result.addToRowSet(new Object[]{"Auto Start", monitor.isAutoStart()});
            result.addToRowSet(new Object[]{"Version", monitor.getVersion()});
            result.addToRowSet(new Object[]{"Last Modified On", DescribeLogMonitorOperation.doFormatDate(monitor.getUpdateTimestamp())});
            result.addToRowSet(new Object[]{"State", this.getState(monitor)});
            result.addToRowSet(new Object[]{"Target Client", monitor.getForwarderState().name()});
            result.addToRowSet(new Object[]{"Last Log Event At", DescribeLogMonitorOperation.doFormatDate(monitor.getLastEventTimestamp())});
            result.addToRowSet(new Object[]{"Last Error", DescribeLogMonitorOperation.skipNull(monitor.getLastError())});
        }
        return new SLResponse(result);
    }

    private String getState(LogMonitor monitor) {
        return monitor.isStarted() ? "STARTED" : "STOPPED";
    }

    private static String doFormatDate(Date date) {
        return date != null ? DescribeLogMonitorOperation.formatDate(date) : "n/a";
    }

    private static RowMetaData createResultDescriptor(Option option) {
        RowMetaData result = new RowMetaData();
        if (option == Option.SOURCES) {
            DescribeLogMonitorOperation.addColumn(result, "Source Type");
            DescribeLogMonitorOperation.addColumn(result, "Source Name");
            DescribeLogMonitorOperation.addColumn(result, "File Path");
            DescribeLogMonitorOperation.addColumn(result, "File Found");
            DescribeLogMonitorOperation.addColumn(result, "Offset");
            DescribeLogMonitorOperation.addColumn(result, "Valid");
            DescribeLogMonitorOperation.addColumn(result, "Error");
        } else if (option == Option.SOURCE_TYPES) {
            DescribeLogMonitorOperation.addColumn(result, "Source Type");
            DescribeLogMonitorOperation.addColumn(result, "Scope");
        } else {
            DescribeLogMonitorOperation.addColumn(result, "Property");
            DescribeLogMonitorOperation.addColumn(result, "Value");
        }
        return result;
    }

    private static enum Option {
        SOURCES,
        SOURCE_TYPES,
        PROPERTIES;

    }

    static class Definition
    extends AbstractSLStatement {
        private Option option;

        Definition(Option option) {
            super(DescribeLogMonitorOperation.NAME);
            this.option = option;
        }

        Option getOption() {
            return this.option;
        }
    }
}

