/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.runtime.mf.operation.frm.FrmFileReader;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.tools.mnode.activator.AbstractActivatorOperation;
import com.streamscape.tools.mnode.activator.AbstractUpgradeOperation;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ImageManifest;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

class DescribeDepotImageOperation
extends AbstractUpgradeOperation {
    public static final String NAME = "describe depot image";

    DescribeDepotImageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE DEPOT IMAGE");
        this.addVersionModifier(true);
        this.syntax.addModifier(new ChoiceModifier(false).addPossibleValues("RELEASE NOTES", "STATUS"));
        this.syntax.setDescription("Describes the specified image.");
        this.syntax.setExamples("describe depot image 3.5.008.55_jdk8\ndescribe depot image 3.5.008.55_jdk8 release notes\ndescribe depot image 3.5.008.55_jdk8 status");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("Version").getValue(), statement.existsModifier("RELEASE NOTES") ? Option.RELEASE_NOTES : (statement.existsModifier("STATUS") ? Option.STATUS : null));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.option == Option.STATUS) {
            return this.invoke((Definition)statement, session, timeout);
        }
        return this.invokeLocal((Definition)statement, (AbstractMFSession)session, timeout);
    }

    @Override
    SLResponse invokeLocal(AbstractActivatorOperation.BroadcastDefinition statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.option == Option.STATUS || definition.validate) {
            return this.fillStatus(definition);
        }
        File imageDir = Activator.getImageDir(definition.version);
        if (!imageDir.exists()) {
            throw new FabricException("Image not found in depot.");
        }
        File imageFile = this.getImageFile(definition.version);
        if (imageFile.exists()) {
            RowSet result;
            block12: {
                result = new RowSet(DescribeDepotImageOperation.createResultDescriptor(definition.option));
                if (definition.option == Option.RELEASE_NOTES) {
                    ImageManifest manifest = Activator.getImageManifest(definition.version);
                    String version = this.getValue("Version", manifest) + "_" + this.getValue("Build", manifest);
                    try (FrmFileReader frmReader = Activator.getImageReader(imageFile.getAbsolutePath());){
                        result.addToRowSet(new Object[]{new String(frmReader.getFile("doc/Release_Notes_" + version + ".txt"))});
                        break block12;
                    }
                    catch (Exception exception) {
                        throw new FabricException("Release Notes not available.", exception);
                    }
                }
                ImageManifest manifest = Activator.getImageManifest(definition.version);
                result.addToRowSet(new Object[]{"Name", definition.version});
                result.addToRowSet(new Object[]{"Release Date", this.getValue("ReleaseDate", manifest)});
                result.addToRowSet(new Object[]{"Version", this.getValue("Version", manifest)});
                result.addToRowSet(new Object[]{"Build", this.getValue("Build", manifest)});
                result.addToRowSet(new Object[]{"Platform", this.getValue("Platform", manifest)});
                result.addToRowSet(new Object[]{"JDK", this.getValue("JDK", manifest)});
                result.addToRowSet(new Object[]{"Import Date", this.getValue("ImportDate", manifest)});
                result.addToRowSet(new Object[]{"Archive", this.getValue("Archive", manifest)});
                result.addToRowSet(new Object[]{"Valid", manifest.isValid()});
            }
            return new SLResponse(result);
        }
        throw new FabricException("Image archive not found in depot.");
    }

    private SLResponse fillStatus(Definition definition) throws Exception {
        String status = null;
        File imageDir = Activator.getImageDir(definition.version);
        if (!imageDir.exists()) {
            status = this.getErrorStatus("Image not found in depot.", definition.validate);
        } else {
            ImageManifest manifest;
            long imageSize;
            File imageFile = this.getImageFile(definition.version);
            if (!imageFile.exists()) {
                status = this.getErrorStatus("Image archive not found in depot.", definition.validate);
            }
            if ((imageSize = imageFile.length()) > 0L) {
                if (definition.imageSize == -1L) {
                    definition.imageSize = imageSize;
                } else if (definition.imageSize != imageSize) {
                    status = this.getErrorStatus("Size of image archive is not valid.", definition.validate);
                }
            }
            if (status == null && !(manifest = Activator.getImageManifest(definition.version)).isValid()) {
                status = this.getErrorStatus("Image manifest is not valid.", definition.validate);
            }
        }
        RowSet result = new RowSet(DescribeDepotImageOperation.createResultDescriptor(Option.STATUS));
        result.addToRowSet(new Object[]{((Activator)this.callable).getNodeName(), this.getHost(), status == null ? "OK" : status});
        return new SLResponse(result);
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException exception) {
            return "n/a";
        }
    }

    private String getErrorStatus(String error, boolean throwException) throws FabricException {
        if (throwException) {
            throw new FabricException(error);
        }
        return "Error: " + error;
    }

    private static RowMetaData createResultDescriptor(Option option) {
        RowMetaData result = new RowMetaData();
        if (option == Option.RELEASE_NOTES) {
            DescribeDepotImageOperation.addColumn(result, "Release Notes");
        } else if (option == Option.STATUS) {
            DescribeDepotImageOperation.addColumn(result, "Node");
            DescribeDepotImageOperation.addColumn(result, "Host");
            DescribeDepotImageOperation.addColumn(result, "Status");
        } else {
            DescribeDepotImageOperation.addColumn(result, "Property");
            DescribeDepotImageOperation.addColumn(result, "Value");
        }
        return result;
    }

    static class Definition
    extends AbstractActivatorOperation.BroadcastDefinition {
        private String version;
        private Option option;
        private long imageSize = -1L;
        private boolean validate = false;

        Definition(String version, Option option) {
            super(DescribeDepotImageOperation.NAME, true);
            this.version = version;
            this.option = option;
        }

        Definition(String version, long imageSize) {
            super(DescribeDepotImageOperation.NAME, true);
            this.version = version;
            if (imageSize > 0L) {
                this.imageSize = imageSize;
            }
            this.validate = true;
            this.local = true;
            this.prepare = false;
        }
    }

    static enum Option {
        RELEASE_NOTES,
        STATUS;

    }
}

