/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

class DescribeActivatorOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "describe activator";

    DescribeActivatorOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE ACTIVATOR");
        this.syntax.setDescription("Shows information about Activator.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(DescribeActivatorOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Mnode Domain", ((Activator)this.callable).getDomain()});
        result.addToRowSet(new Object[]{"Mnode Name", ((Activator)this.callable).getNodeName()});
        result.addToRowSet(new Object[]{"Mnode State", this.getMnodeState()});
        result.addToRowSet(new Object[]{"Mnode PID", ((Activator)this.callable).getMnodePid()});
        if (((Activator)this.callable).getMnodeError() != null) {
            result.addToRowSet(new Object[]{"Mnode Error", ((Activator)this.callable).getMnodeError()});
        }
        result.addToRowSet(new Object[]{"User", ((Activator)this.callable).getUserName()});
        result.addToRowSet(new Object[]{"Host", this.getHost()});
        result.addToRowSet(new Object[]{"PID", this.getProcessId()});
        result.addToRowSet(new Object[]{"Current Time", DescribeActivatorOperation.formatDate(new Date())});
        result.addToRowSet(new Object[]{"Working Dir", new File(".").getCanonicalPath().replace(File.separatorChar, '/')});
        result.addToRowSet(new Object[]{"Access Point", ((Activator)this.callable).getAccessPoint()});
        result.addToRowSet(new Object[]{"Log Monitor", this.getLogMonitorState(((Activator)this.callable).getLogMonitor())});
        return new SLResponse(result);
    }

    private String getMnodeState() {
        return ((Activator)this.callable).isMnodeConnected() ? "CONNECTED" : (((Activator)this.callable).isMnodeStarted() ? "DISCONNECTED" : "STOPPED");
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException exception) {
            return "n/a";
        }
    }

    private String getProcessId() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            return Integer.toString(Integer.parseInt(jvmName.substring(0, jvmName.indexOf(64))));
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    private String getLogMonitorState(LogMonitor monitor) {
        return monitor == null ? "UNLOADED" : (monitor.isStarted() ? "STARTED" : "STOPPED");
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeActivatorOperation.addColumn(result, "Property");
        DescribeActivatorOperation.addColumn(result, "Value");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(DescribeActivatorOperation.NAME);
        }
    }
}

