/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.runtime.mf.operation.SetParametersModifier;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.exchange.FabricCluster;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.tools.mnode.activator.AbstractCreateDropClusterOperation;

class CreateClusterOperation
extends AbstractCreateDropClusterOperation {
    public static final String NAME = "create cluster";

    CreateClusterOperation() {
        super(NAME);
        this.syntax.setDescription("Creates a new cluster with the specified parameters.\nThis cluster will include the associated management node and all of its task nodes.\n" + this.getDescriptionEnd());
        this.syntax.setSyntaxDescription("Optional parameters:\n\n  description       - Description of the cluster.\n  set properties    - List of the cluster properties.\n                      This list consist of pairs <name> = '<value>' which must be separated by comma:\n                        name  - the name of the property.\n                        value - the value of the property.\n" + this.getSyntaxDescriptionEnd());
        this.syntax.setExamples("create cluster Primary restart mnode\ncreate cluster Primary description 'Primary cluster.' set properties (name1 = 'value1')");
    }

    @Override
    void addOtherParameters() {
        this.syntax.addActionParameter(new IdentifierParameter("Name"));
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\''))));
        this.syntax.addModifier(new SetParametersModifier("SET PROPERTIES", "Properties", false));
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new AbstractCreateDropClusterOperation.Definition(NAME, statement.getParameter("Name").getValue(), statement.existsParameter("Description") ? statement.getParameter("Description").getValue() : null, SetParametersModifier.getValue(statement, "Properties"), this.getTimeout(statement, 90L), statement.existsModifier("RESTART MNODE"));
    }

    @Override
    String getPreRequestMessage() {
        return "Adding cluster descriptor to management node and its tnodes...";
    }

    @Override
    int getRequestId() {
        return 12;
    }

    @Override
    Object getRequestData(AbstractCreateDropClusterOperation.Definition definition) {
        return new FabricCluster(definition.clusterName, definition.description, definition.properties);
    }

    @Override
    String getThreadName() {
        return "FSYS:Activator.CreateCluster";
    }
}

