/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.log.monitor.LogEventSource;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.log.monitor.Utils;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;
import com.streamscape.tools.mnode.activator.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class AddLogEventSourceOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "add log event source";

    AddLogEventSourceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD LOG EVENT SOURCE");
        this.syntax.addModifier((AbstractModifier)new Modifier("TYPE").addParameter((SyntaxParameter)new IdentifierParameter("SourceType").setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<Activator>(this){

            @Override
            protected List<String> doGetCompletions(String processedScript, MFSession session) {
                return Arrays.asList("MNODE", "TNODE");
            }
        })));
        this.syntax.addModifier(((ChoiceModifier)new ChoiceModifier().addModifier((AbstractModifier)new Modifier("NAME").addParameter(new IdentifierParameter("SourceName")))).addPossibleValue("ALL"));
        this.syntax.addModifier((AbstractModifier)new Modifier("FILE", false).addParameter(new LocalPathParameter("LogFilename")));
        this.syntax.addModifier((AbstractModifier)new Modifier("OFFSET", false).addParameter(new IntegerParameter("LinesOffset")));
        this.syntax.setDescription("Adds a new log event source to configuration of Log Monitor.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   type   - Type of the source.\n            This parameter has no restrictions on values.\n            Standard type is a node type (MANAGEMENT_NODE (MNODE) or TASK_NODE (TNODE)).\n   name   - Name of the source.\n            This parameter has no restrictions on values.\n            Standard name is a node name.\n   all    - Automatically adds all possible sources for the specified source type:\n               - MANAGEMENT_NODE: Adds sources for a local management node and its task nodes.\n               - TASK_NODE:       Adds sources for all task nodes of a local management node.\n\nOptional parameters:\n\n   file   - Path to the log file.\n            If path is not specified, it is resolved automatically based on the specified type and source.\n            Usually there is no need to specify the file path manually.\n   offset - Defines the place (line number) where the monitor will start reading of the log file.\n            Values can be following:\n               - Null value means reading from the end of the file.\n               - Negative values means a shift up from the end of the file.\n               - Positive values means a shift down from the beginning of the file.\n            Default value is 0.");
        this.syntax.setExamples("add log event source type TNODE name Node1\nadd log event source type TNODE all\nadd log event source type MNODE name Node1 offset 1\nadd log event source type MNODE all\nadd log event source type MNODE all offset 1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        LogEventSource source = new LogEventSource(AddLogEventSourceOperation.getSourceType(statement), statement.existsParameter("SourceName") ? statement.getParameter("SourceName").getValue() : null);
        if (statement.existsParameter("LogFilename")) {
            source.setLogFilename(statement.getParameter("LogFilename").getValue());
        }
        if (statement.existsParameter("LinesOffset")) {
            source.setLinesOffset(Integer.parseInt(statement.getParameter("LinesOffset").getValue()));
        }
        return new Definition(source, statement.existsModifier("ALL"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ArrayList<LogEventSource> sources = new ArrayList<LogEventSource>();
        if (definition.all) {
            if (!Utils.equalsNullSafe(definition.source.getSourceType(), FabricNodeRole.MANAGEMENT_NODE.name()) && !Utils.equalsNullSafe(definition.source.getSourceType(), FabricNodeRole.TASK_NODE.name())) {
                throw new FabricException("Parameter 'all' can be used only with MNODE or TNODE source types.");
            }
            try {
                if (Utils.equalsNullSafe(definition.source.getSourceType().toUpperCase(), FabricNodeRole.MANAGEMENT_NODE.name())) {
                    sources.add(new LogEventSource(FabricNodeRole.MANAGEMENT_NODE.name(), ((Activator)this.callable).getNodeName(), definition.source.getLinesOffset()));
                }
                ((Activator)this.callable).getTnodeNames().forEach(name -> sources.add(new LogEventSource(FabricNodeRole.TASK_NODE.name(), (String)name, definition.source.getLinesOffset())));
            }
            catch (Exception exception) {
                throw new FabricException("Obtaining task node names from management node failed.", exception);
            }
        } else {
            sources.add(definition.source);
        }
        LogMonitor monitor = this.getLogMonitor();
        if (monitor.getConfiguration() == null) {
            monitor.setConfiguration(this.makeLogMonitorConfiguration());
        }
        monitor.addSources(sources, null);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private LogEventSource source;
        private boolean all;

        Definition(LogEventSource source, boolean all) {
            super(AddLogEventSourceOperation.NAME);
            this.source = source;
            this.all = all;
        }

        LogEventSource getSource() {
            return this.source;
        }

        boolean isAll() {
            return this.all;
        }
    }
}

