/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.log.monitor.LogMonitor;
import com.streamscape.tools.mnode.activator.AbstractLogMonitorOperation;

class AddExternalLogEventTypeOperation
extends AbstractLogMonitorOperation {
    public static final String NAME = "add external log event type";

    AddExternalLogEventTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ADD EXTERNAL LOG EVENT TYPE");
        this.syntax.addActionParameter(new IdentifierParameter("SourceType"));
        this.syntax.setDescription("Adds a new external Log Event source type to the configuration of Log Monitor.\nSource type specifies the external Log Event identifier associated with a Log Event to be forwarded.\nWhen Log Events are raised anywhere in the sysplex, assuming their Event Scope is GLOBAL\nand their sourceType property matches the registered Source Type, such events will be automatically forwarded \nto the target system as configured by the Log Monitor and Activator framework.\n\nSource types are case-sensitive.");
        this.syntax.setExamples("add external log event type TestType");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("SourceType").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        LogMonitor monitor = this.getLogMonitor();
        if (monitor.getConfiguration() == null) {
            monitor.setConfiguration(this.makeLogMonitorConfiguration());
        }
        if (monitor.existsExternalSourceType(definition.type)) {
            throw new FabricException("Source type already exists.");
        }
        monitor.addExternalSourceType(definition.type);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        private String type;

        Definition(String type) {
            super(AddExternalLogEventTypeOperation.NAME);
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

