/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.ThreadPoolType;
import com.streamscape.lib.evqueue.EventQueue;
import com.streamscape.lib.evqueue.EventQueueListener;
import com.streamscape.lib.evqueue.FlowControlMode;
import com.streamscape.lib.evqueue.IllegalQueueStateException;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractClientContext;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.SLFileMessageListener;
import com.streamscape.sef.dispatcher.SLFileMessageProcessor;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.DefaultConnectionStateHandler;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.slex.slang.SpecialSLSession;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorNetworkConnection;

public class ActivatorSLSessionImpl
extends AbstractSpecialSLSession
implements SpecialSLSession {
    public static final String SESSION_MANAGER_NAME = "ActivatorSessionManager";
    public static final String SESSION_NAME = "ActivatorSession";
    private ActivatorNetworkConnection connection;
    private EventQueue<SLMessage> slMessageQueue;
    private SLFileMessageProcessor slFileMessageProcessor;
    private SLFileMessageListener slFileMessageListener;
    private static final LongNumberAllocatorSimple SESSION_NAME_ALLOCATOR = new LongNumberAllocatorSimple();

    public ActivatorSLSessionImpl(AbstractClientContext context, String url, String userName, String password, long timeout, boolean fromSlangTool) throws SLSessionException {
        super(context, SESSION_NAME_ALLOCATOR.getNumber(), url, userName, password, timeout, fromSlangTool);
    }

    @Override
    protected AbstractSpecialSLSession.ConnectReplyData connect(long timeout, String userName, String password, boolean fromSlangTool) throws Exception {
        try {
            this.connection = new ActivatorNetworkConnection.ConnectionFactory(new DefaultConnectionStateHandler(){

                @Override
                public void onOpen(Connection connection, boolean isOutgoing) throws FabricException {
                    connection.setPacketHandler(new PacketHandlerImpl(connection));
                }

                @Override
                public void onClose(Connection connection, boolean isNormal) {
                    if (!isNormal) {
                        ActivatorSLSessionImpl.this.forcedClose();
                    }
                }
            }, ThreadPoolType.DYNAMIC, 10).createConnection(new LinkAddress(this.url), timeout);
            this.connection.open(true);
        }
        catch (Throwable exception) {
            throw new FabricException("Opening connection to Activator failed.", exception);
        }
        try {
            AbstractSpecialSLSession.ConnectReplyData result = this.connection.connect((byte)2, this.getComponentName(), this.getName(), userName, password, fromSlangTool);
            this.createSLFileMessageListener();
            return result;
        }
        catch (Throwable exception) {
            Activator.logException(exception, true);
            Activator.logError("Opening session to Activator failed.");
            this.connection.close(true);
            this.connection = null;
            throw new FabricException("Opening session to Activator failed.", exception);
        }
    }

    @Override
    protected void closeConnection() {
        this.destroySLMessageQueue();
        this.connection.close(true);
    }

    protected static String getMFSessionName(long id) {
        return ActivatorSLSessionImpl.getMFSessionName("Activator", id);
    }

    @Override
    protected String getPrefix() {
        return "Activator";
    }

    @Override
    protected SLResponse doInvokeRequest(CloneableDataObject wrapper, long timeout) throws Exception {
        return (SLResponse)this.connection.invokeRequest((byte)8, wrapper, timeout);
    }

    @Override
    public synchronized void setSLMessageListener(SLMessageListener listener) throws SLSessionException {
        this.checkOpened();
        if (this.slMessageQueue == null) {
            this.slMessageQueue = new EventQueue<SLMessage>("FSYS:ActivatorSLSession", new SLMessageQueueListener(listener));
            this.slMessageQueue.setFlowControlMode(FlowControlMode.DROP);
            this.slMessageQueue.start();
        } else {
            try {
                this.slMessageQueue.setListener(new SLMessageQueueListener(listener));
            }
            catch (IllegalQueueStateException illegalQueueStateException) {
                // empty catch block
            }
        }
        this.slFileMessageProcessor.setSLMessageListener(listener);
    }

    private void destroySLMessageQueue() {
        if (this.slMessageQueue != null) {
            this.slMessageQueue.close();
            this.slMessageQueue.stop();
            this.slMessageQueue = null;
        }
    }

    private void createSLFileMessageListener() {
        this.slFileMessageProcessor = new SLFileMessageProcessor();
        this.slFileMessageListener = new SLFileMessageListener(this.slFileMessageProcessor);
    }

    @Override
    public PromptSLResponse getPrompt() {
        return ActivatorSLSessionImpl.getPrompt(this.getUserName(), this.getNodeName());
    }

    public static PromptSLResponse getPrompt(String userName, String nodeName) {
        PromptSLResponse result = new PromptSLResponse(userName, nodeName, "Activator", "Activator");
        result.setPrompt(nodeName + "[Activator]");
        return result;
    }

    @Override
    protected void logInfo(String message) {
        Trace.logInfo(Activator.class, message);
    }

    private static class SLMessageQueueListener
    implements EventQueueListener<SLMessage> {
        SLMessageListener listener;

        SLMessageQueueListener(SLMessageListener listener) {
            this.listener = listener;
        }

        @Override
        public void onObject(SLMessage message) {
            this.listener.onMessage(message);
        }
    }

    private class PacketHandlerImpl
    extends ActivatorNetworkConnection.DefaultPacketHandler {
        public PacketHandlerImpl(Connection connection) {
            super(connection);
        }

        @Override
        public void onPacket(byte[] packet) {
            try {
                Object messageData = this.connection.unpack(this.getMessageBytes(packet));
                if (messageData instanceof SLMessage && ActivatorSLSessionImpl.this.slMessageQueue != null) {
                    ActivatorSLSessionImpl.this.slMessageQueue.enqueue((SLMessage)messageData);
                }
            }
            catch (Exception exception) {
                Activator.logException((Throwable)exception, "Packet processing failed.");
            }
        }

        @Override
        protected Object processRequest(byte type, byte[] bytes, Object data, long timeout) throws FabricException {
            switch (type) {
                case 6: {
                    try {
                        return ActivatorSLSessionImpl.this.slFileMessageListener.onRequest((ImmutableEventDatagram)data);
                    }
                    catch (FabricRequestException exception) {
                        return exception;
                    }
                }
            }
            return super.processRequest(type, bytes, data, timeout);
        }
    }
}

