/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.mnode.activator;

import com.streamscape.sdo.IAbstractEvent;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.slex.file.SLFileMessageRaiser;
import com.streamscape.tools.mnode.activator.Activator;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import java.io.IOException;

class ActivatorSLFileMessageRaiserRemote
implements SLFileMessageRaiser {
    private ActivatorMFSession session;

    ActivatorSLFileMessageRaiserRemote(ActivatorMFSession session) {
        this.session = session;
    }

    @Override
    public void open() throws IOException {
        try {
            this.session.invokeRequest((byte)12, this.session, 5000L);
        }
        catch (Exception exception) {
            throw new IOException("Opening ActivatorSLFileMessageRaiserRemote failed.", exception);
        }
    }

    @Override
    public void close() {
        try {
            this.session.invokeRequest((byte)13, this.session, 5000L);
        }
        catch (Exception exception) {
            Activator.logException(exception, "Closing ActivatorSLFileMessageRaiserRemote failed.", true);
        }
    }

    @Override
    public SLFileMessage raise(SLFileMessage fileMessage, long timeout) throws IOException {
        try {
            fileMessage.setComponentName(this.session.getComponentName());
            fileMessage.setSLSessionName(this.session.getSLSessionName());
            fileMessage.setTimeout(timeout);
            Object response = this.session.invokeRequest((byte)6, new WrapperEvent(fileMessage), timeout);
            if (response instanceof SLFileMessage) {
                return (SLFileMessage)response;
            }
            if (response instanceof OpaqueDatagram) {
                return (SLFileMessage)((OpaqueDatagram)response).getData();
            }
            if (response instanceof FabricRequestException) {
                throw new IOException(((FabricRequestException)response).getCause());
            }
            if (response instanceof Throwable) {
                throw new IOException((Throwable)response);
            }
            throw new Exception("Wrong response received '" + response.getClass().getSimpleName() + "', but expected 'SLFileMessage' or 'OpaqueDatagram'.");
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception);
        }
    }

    private static class WrapperEvent
    extends IAbstractEvent
    implements OpaqueDatagram {
        private SLFileMessage data;

        WrapperEvent(SLFileMessage data) {
            this.data = data;
        }

        @Override
        public void setData(Object newData) throws SDOException, SecurityViolationException {
            this.data = (SLFileMessage)newData;
        }

        @Override
        public SLFileMessage getData() throws SDOException {
            return this.data;
        }
    }
}

